/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.search;

import com.twitterapime.model.DefaultEntity;
import com.twitterapime.rest.GeoLocation;
import com.twitterapime.rest.UserAccount;
import java.util.Hashtable;

public final class Tweet
extends DefaultEntity {
    public static final int MAX_CHARACTERS = 140;

    public Tweet() {
    }

    public Tweet(Hashtable data) {
        super(data);
    }

    public Tweet(String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null");
        }
        Hashtable<String, String> data = new Hashtable<String, String>();
        data.put("TWEET_CONTENT", content);
        this.setData(data);
        this.validateContent();
    }

    public Tweet(String content, GeoLocation location) {
        this(content);
        if (location != null) {
            this.data.put("TWEET_LOCATION", location);
        }
    }

    public Tweet(String toUserNameOrID, String content) {
        if (toUserNameOrID == null) {
            throw new IllegalArgumentException("To username/ID must not be empty/null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null");
        }
        Hashtable<String, Object> tweetData = new Hashtable<String, Object>();
        tweetData.put("TWEET_AUTHOR_USERNAME", toUserNameOrID);
        tweetData.put("TWEET_CONTENT", content);
        Hashtable<String, String> usrData = new Hashtable<String, String>();
        usrData.put("USERACCOUNT_USER_NAME", toUserNameOrID);
        usrData.put("USERACCOUNT_ID", toUserNameOrID);
        tweetData.put("TWEET_USER_ACCOUNT", new UserAccount(usrData));
        this.setData(tweetData);
        this.validateRecipient();
        this.validateContent();
    }

    public void validateContent() {
        String text = this.getString("TWEET_CONTENT");
        if (text == null || (text = text.trim()).length() == 0) {
            throw new IllegalArgumentException("Content must not be empty/null.");
        }
        if (text.length() > 140) {
            throw new IllegalArgumentException("Content must not be longer than140 characters.");
        }
    }

    public void validateRecipient() {
        String r = this.getString("TWEET_AUTHOR_USERNAME");
        if (r == null || (r = r.trim()).length() == 0) {
            UserAccount ua = this.getUserAccount();
            if (ua != null) {
                r = ua.getString("USERACCOUNT_USER_NAME");
                if (!(r != null && (r = r.trim()).length() != 0 || (r = ua.getString("USERACCOUNT_ID")) != null && (r = r.trim()).length() != 0)) {
                    throw new IllegalArgumentException("Recipient's username/ID must not be empty/null.");
                }
            } else {
                throw new IllegalArgumentException("Recipient's username/ID must not be empty/null.");
            }
        }
    }

    public UserAccount getUserAccount() {
        return (UserAccount)this.data.get("TWEET_USER_ACCOUNT");
    }

    public UserAccount getRecipientAccount() {
        return (UserAccount)this.data.get("TWEET_RECIPIENT_ACCOUNT");
    }

    public Tweet getRepostedTweet() {
        return (Tweet)this.data.get("TWEET_REPOSTED_TWEET");
    }

    public GeoLocation getLocation() {
        return (GeoLocation)this.data.get("TWEET_LOCATION");
    }
}

