/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.xauth;

import com.twitterapime.util.QSort;
import com.twitterapime.util.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;

final class OAuthParameters {
    private Hashtable params;

    public OAuthParameters(String consumerKey) {
        if (consumerKey == null || (consumerKey = consumerKey.trim()).length() == 0) {
            throw new IllegalArgumentException("Consumer key must not be empty/null");
        }
        this.params = new Hashtable();
        this.params.put("oauth_timestamp", this.getTimestampInSeconds());
        this.params.put("oauth_signature_method", "HMAC-SHA1");
        this.params.put("oauth_version", "1.0");
        this.params.put("oauth_nonce", this.getTimestampInSeconds());
        this.params.put("oauth_consumer_key", consumerKey);
    }

    public String getSortedEncodedParamsAsString() {
        StringBuffer buffer = new StringBuffer();
        String[] sKeys = this.sortedKeys();
        for (int i = 0; i < sKeys.length; ++i) {
            buffer.append(StringUtil.encode(sKeys[i], "UTF-8"));
            buffer.append('=');
            buffer.append(StringUtil.encode((String)this.params.get(sKeys[i]), "UTF-8"));
            if (i + 1 >= sKeys.length) continue;
            buffer.append('&');
        }
        return buffer.toString();
    }

    public String getAuthorizationHeaderValue() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("OAuth ");
        String[] sKeys = this.sortedKeys();
        for (int i = 0; i < sKeys.length; ++i) {
            if (!sKeys[i].startsWith("oauth_")) continue;
            buffer.append(sKeys[i]);
            buffer.append('=');
            buffer.append('\"');
            buffer.append(StringUtil.encode((String)this.params.get(sKeys[i]), "UTF-8"));
            buffer.append("\", ");
        }
        return buffer.toString().substring(0, buffer.length() - 2);
    }

    public void put(String key, String value) {
        this.params.put(key, value);
    }

    private String[] sortedKeys() {
        int i = 0;
        Object[] sKeys = new String[this.params.size()];
        Enumeration keys = this.params.keys();
        while (keys.hasMoreElements()) {
            sKeys[i++] = (String)keys.nextElement();
        }
        QSort qsort = new QSort();
        qsort.quicksort(sKeys, 0, sKeys.length - 1);
        return sKeys;
    }

    private String getTimestampInSeconds() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }
}

