/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.platform;

import com.twitterapime.platform.PlatformProvider;
import java.util.Vector;

public final class PlatformProviderSelector {
    private static final PlatformProvider javameProvider = new PlatformProvider(1, "Java Micro Edition platform");
    private static final PlatformProvider androidProvider = new PlatformProvider(2, "Android platform");
    private static final PlatformProvider defaultPlatform = javameProvider;
    private static PlatformProvider currentPlatform;

    public static PlatformProvider[] getAvailableProviders() {
        Vector<PlatformProvider> v = new Vector<PlatformProvider>(2);
        v.addElement(javameProvider);
        v.addElement(androidProvider);
        Object[] plats = new PlatformProvider[v.size()];
        v.copyInto(plats);
        return plats;
    }

    public static PlatformProvider getCurrentProvider() {
        return currentPlatform;
    }

    public static PlatformProvider getDefaultProvider() {
        return defaultPlatform;
    }

    public static void select(PlatformProvider pp) {
        if (pp == null) {
            throw new IllegalArgumentException("Platform must not be null.");
        }
        currentPlatform = pp;
    }

    private PlatformProviderSelector() {
    }

    static {
        PlatformProviderSelector.select(defaultPlatform);
    }
}

