/*
 * Decompiled with CFR 0.152.
 */
package app.module.ui.models;

import app.module.ui.helpers.WidgetHelper;
import app.module.ui.models.BaseContainerWidget;
import app.module.ui.models.UITheme;
import app.module.ui.models.Widget;
import javax.microedition.lcdui.Graphics;

public abstract class BaseContainerManager
extends BaseContainerWidget {
    protected Widget focusedWidget = null;
    protected int oldX = 0;
    protected int oldY = 0;
    protected boolean isDragging = false;
    protected UITheme theme = null;

    public BaseContainerManager(UITheme theme) {
        this.theme = theme;
    }

    public void paint(Graphics g) {
        g.setColor(this.theme.getAppBgColor());
        int absX = this.getAbsoluteX();
        int absY = this.getAbsoluteY();
        g.fillRect(this.getAbsoluteX(), this.getAbsoluteY(), this.getTotalWidth() - 1, this.getTotalHeight() - 1);
        for (int i = 0; i < this.getChildCount(); ++i) {
            Widget temp = this.getWidget(i);
            if (!temp.getClipRect().isVisible()) continue;
            temp.paint(g);
        }
    }

    public boolean handleKeyPressed(int key) {
        return false;
    }

    public void removeWidget(Widget w) {
        super.removeWidget(w);
        this.onFocus();
    }

    public boolean onFocus() {
        this.isFocused = false;
        if (this.focusedWidget == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (!this.getWidget(i).isFocusable()) continue;
                this.focusedWidget = this.getWidget(i);
                break;
            }
        }
        if (this.focusedWidget != null && this.indexOf(this.focusedWidget) == -1) {
            this.focusedWidget = null;
            return this.onFocus();
        }
        if (this.focusedWidget != null) {
            this.isFocused = this.focusedWidget.onFocus();
            this.scrollToWidget(this.focusedWidget);
            return this.isFocused;
        }
        return false;
    }

    public boolean onLostFocus() {
        if (this.focusedWidget != null) {
            this.isFocused = this.focusedWidget.onLostFocus();
            this.focusedWidget.requestRepaint();
            return this.isFocused;
        }
        this.isFocused = false;
        return false;
    }

    public boolean isFocusable() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!this.getWidget(i).isFocusable()) continue;
            return true;
        }
        return false;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public boolean handlePointerPressed(int x, int y) {
        this.oldX = x;
        this.oldY = y;
        Widget w = this.getWidgetAt(x, y);
        if (w != null) {
            return !w.handlePointerPressed(x, y);
        }
        return false;
    }

    public Widget getWidgetAt(int x, int y) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Widget temp = this.getWidget(i);
            if (temp.getAbsoluteX() > x || temp.getAbsoluteX() + temp.getTotalWidth() < x || temp.getAbsoluteY() > y || temp.getAbsoluteY() + temp.getTotalHeight() < y) continue;
            return temp;
        }
        return null;
    }

    public boolean scrollToWidget(Widget w) {
        boolean doScroll;
        if (w == null) {
            return false;
        }
        boolean scroll = false;
        int maxScroll = Math.max(this.getPreferredContentWidth() - this.getContentWidth(), 0);
        int neededScrollDelta = WidgetHelper.getXDistanceBetween(w, this);
        if (neededScrollDelta <= 0 || this.getXScroll() + neededScrollDelta >= this.getXScroll() + this.getTotalWidth()) {
            if (this.getXScroll() + neededScrollDelta >= maxScroll) {
                this.setXScroll(maxScroll);
            } else {
                this.setXScroll(this.getXScroll() + neededScrollDelta);
            }
            scroll = true;
        }
        maxScroll = Math.max(this.getPreferredContentHeight() - this.getContentHeight(), 0);
        neededScrollDelta = WidgetHelper.getYDistanceBetween(w, this);
        if (neededScrollDelta <= 0 || this.getYScroll() + neededScrollDelta >= this.getYScroll() + this.getTotalHeight()) {
            if (this.getYScroll() + neededScrollDelta >= maxScroll) {
                this.setYScroll(maxScroll);
            } else {
                this.setYScroll(this.getYScroll() + neededScrollDelta);
            }
            scroll = true;
        }
        boolean parentScroll = false;
        if (this.parent != null) {
            parentScroll = this.parent.scrollToWidget(w);
        }
        boolean bl = doScroll = parentScroll || scroll;
        if (doScroll) {
            this.requestRepaint();
        }
        return doScroll;
    }

    public void focusWidget(Widget w) {
        if (this.indexOf(w) >= 0 && w.isFocusable()) {
            Widget oldFocusedWidget = this.focusedWidget;
            if (this.focusedWidget != null) {
                this.focusedWidget.onLostFocus();
            }
            this.focusedWidget = w;
            this.focusedWidget.onFocus();
            if (!this.isFocused()) {
                this.getParent().focusWidget(this);
            }
            if (!this.scrollToWidget(w)) {
                this.focusedWidget.requestRepaint();
                if (oldFocusedWidget != null) {
                    oldFocusedWidget.requestRepaint();
                }
            }
        }
    }

    public boolean handlePointerReleased(int x, int y) {
        if (this.isDragging) {
            this.isDragging = false;
            return true;
        }
        Widget w = this.getWidgetAt(x, y);
        if (w != null) {
            return w.handlePointerReleased(x, y);
        }
        return false;
    }

    public boolean handlePointerDragged(int x, int y) {
        Widget w = this.getWidgetAt(x, y);
        if (w != null && w.handlePointerDragged(x, y)) {
            return true;
        }
        this.isDragging = true;
        return false;
    }

    public int getOldX() {
        return this.oldX;
    }

    public int getOldY() {
        return this.oldY;
    }

    public void setOldX(int x) {
        this.oldX = x;
    }

    public void setOldY(int y) {
        this.oldY = y;
    }

    public Widget getFocusedWidget() {
        return this.focusedWidget;
    }

    public abstract void doLayout();

    public abstract int getPreferredContentHeight();

    public abstract int getPreferredContentWidth();
}

