/*
 * Decompiled with CFR 0.152.
 */
package app.views;

import app.classes.Defaults;
import app.models.Tweet;
import app.module.L10n.classes.Locale;
import app.module.ui.classes.GameCanvasView;
import app.module.ui.classes.HorizontalContainer;
import app.module.ui.classes.InputStringItem;
import app.module.ui.classes.SimpleTextButton;
import app.module.ui.classes.StringItem;
import app.module.ui.classes.VerticalContainer;
import app.module.ui.models.CallbackHandler;
import app.module.ui.models.UITheme;
import com.apress.framework.core.Application;
import com.apress.framework.objecttypes.Event;

public class MainForm
extends GameCanvasView
implements CallbackHandler {
    VerticalContainer tweetsContainer = null;
    HorizontalContainer commandButtons = null;
    InputStringItem newTweet = null;
    SimpleTextButton nextTweets = null;
    SimpleTextButton showSettingsForm = null;

    public void addTweet(Tweet tweet) {
        String text = tweet.getAuthor() + " : " + tweet.getBody();
        StringItem item = new StringItem(text, this.tweetsContainer.getTotalWidth() - 20, 100, this, Defaults.THEME);
        this.tweetsContainer.addWidget(item);
        this.tweetsContainer.doLayout();
    }

    public MainForm(UITheme theme) {
        super(false, theme);
        this.newTweet = new InputStringItem(Locale.get("tweets.new.prompt"), Locale.get("tweets.new.prompt"), Locale.get("text.general.ok"), Locale.get("text.general.cancel"), this.getContentWidth() - 10, 100, this, theme);
        this.tweetsContainer = new VerticalContainer(theme);
        this.nextTweets = new SimpleTextButton(Locale.get("tweets.next.label"), this, theme);
        this.showSettingsForm = new SimpleTextButton(Locale.get("settings.form.button.label"), this, theme);
        this.commandButtons = new HorizontalContainer(theme);
        this.commandButtons.addWidget(this.nextTweets);
        this.commandButtons.addWidget(this.showSettingsForm);
        this.addWidget(this.newTweet);
        this.addWidget(this.tweetsContainer);
        this.addWidget(this.commandButtons);
        this.doLayout();
        this.onFocus();
    }

    public void doLayout() {
        this.commandButtons.doLayout();
        this.tweetsContainer.setContentHeight(this.getTotalHeight() - this.commandButtons.getTotalHeight() - this.newTweet.getTotalHeight() - 20);
        this.tweetsContainer.setContentWidth(this.getTotalWidth());
        super.doLayout();
    }

    public boolean doCallback(Event event) {
        if (40001 == event.getType()) {
            if (this.nextTweets == event.getPayload()) {
                Event evt = new Event(5, 20001, null);
                Application.getMainEventController().queueEvent(evt);
                return true;
            }
            if (this.showSettingsForm == event.getPayload()) {
                Event evt = new Event(5, 10003, null);
                Application.getMainEventController().queueEvent(evt);
                return true;
            }
        } else if (40002 == event.getType()) {
            Tweet tweet = new Tweet(null, this.newTweet.getText(), null);
            Event evt = new Event(5, 20003, tweet);
            Application.getMainEventController().queueEvent(evt);
            this.newTweet.setText(Locale.get("tweets.new.prompt"));
            return true;
        }
        return false;
    }
}

