/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.util;

public class QSort {
    private boolean isAscending = true;

    public void setAscendingSortEnabled(boolean enabled) {
        this.isAscending = enabled;
    }

    public boolean isAscendingSort() {
        return this.isAscending;
    }

    public void quicksort(Object[] items, int s, int e) {
        if (e <= s) {
            return;
        }
        int i = this.partition(items, s, e);
        this.quicksort(items, s, i - 1);
        this.quicksort(items, i + 1, e);
    }

    protected Object getElement(Object ob) {
        return ob;
    }

    protected boolean lesser(Object i1, Object i2) {
        if (i1 != null && i2 == null) {
            return true;
        }
        if (i1 == null) {
            return false;
        }
        return i1.toString().compareTo(i2.toString()) < 0;
    }

    protected boolean greater(Object i1, Object i2) {
        if (i1 != null && i2 == null) {
            return true;
        }
        if (i1 == null) {
            return false;
        }
        return i1.toString().compareTo(i2.toString()) > 0;
    }

    protected void swap(Object[] its, int i1, int i2) {
        Object auxo = its[i1];
        its[i1] = its[i2];
        its[i2] = auxo;
    }

    private int partition(Object[] a, int l, int r) {
        int i = l - 1;
        int j = r;
        Object v = this.getElement(a[r]);
        if (this.isAscending) {
            while (true) {
                if (this.lesser(this.getElement(a[++i]), v)) {
                    continue;
                }
                while (this.lesser(v, this.getElement(a[--j])) && j != l) {
                }
                if (i < j) {
                    this.swap(a, i, j);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                if (this.greater(this.getElement(a[++i]), v)) {
                    continue;
                }
                while (this.greater(v, this.getElement(a[--j])) && j != l) {
                }
                if (i >= j) break;
                this.swap(a, i, j);
            }
        }
        this.swap(a, i, r);
        return i;
    }
}

