/*
 * Decompiled with CFR 0.152.
 */
package app.module.persistence.models;

import app.module.persistence.classes.RecordWriter;
import app.module.persistence.models.ByteSerializer;
import java.io.ByteArrayOutputStream;

public class ByteRecordWriter
implements RecordWriter {
    ByteArrayOutputStream os = new ByteArrayOutputStream();
    ByteSerializer bs = new ByteSerializer();

    protected void writeRawByteArray(byte[] data) {
        try {
            this.os.write(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeInt(int value) {
        this.writeRawByteArray(this.bs.serializeInt(value));
    }

    public void writeLong(long value) {
        this.writeRawByteArray(this.bs.serializeLong(value));
    }

    public void writeString(String value) {
        byte[] rawStringData = this.bs.serializeString(value);
        this.writeRawByteArray(this.bs.serializeInt(rawStringData.length));
        this.writeRawByteArray(rawStringData);
    }

    public void writeBoolean(boolean value) {
        this.writeRawByteArray(this.bs.serializeBoolean(value));
    }

    public byte[] getCurrentResult() {
        return this.os.toByteArray();
    }

    public void writeByte(byte value) {
        this.writeRawByteArray(new byte[]{value});
    }

    public void reset() {
        this.os.reset();
    }
}

