/*
 * Decompiled with CFR 0.152.
 */
package app.module.persistence.helpers;

import app.module.persistence.classes.PersistenceProvider;
import app.module.persistence.helpers.TOC;

public class SimplifiedPersistenceHelper {
    PersistenceProvider provider;
    TOC toc;

    public SimplifiedPersistenceHelper(PersistenceProvider provider) {
        this.provider = provider;
        this.toc = new TOC(provider);
    }

    public void store(String key, byte[] data) {
        int index = this.toc.getIndexFor(key);
        if (index != -1) {
            this.provider.overwriteRecord(index, data);
        } else {
            index = this.provider.createRecord(data);
            this.toc.addEntry(key, index);
        }
    }

    public byte[] getRecord(String key) {
        int index = this.toc.getIndexFor(key);
        if (index != -1) {
            return this.provider.getRecord(index);
        }
        return null;
    }

    public void delete(String key) {
        int index = this.toc.getIndexFor(key);
        if (index != -1) {
            this.provider.deleteRecord(index);
            this.toc.deleteEntry(key);
        }
    }

    public void close() {
        this.toc.save();
        this.provider.close();
    }
}

