/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.search;

import com.twitterapime.search.Query;
import java.util.Calendar;
import java.util.Date;

public final class QueryComposer {
    static final String PM_FILTER_LINKS = "filter=links";
    static final String PM_FROM = "from=";
    static final String PM_POSITIVE_ATTITUDE = "tude[]=:)";
    static final String PM_NEGATIVE_ATTITUDE = "tude[]=:(";
    static final String PM_ASKING_QUESTION = "tude[]=?";
    static final String PM_CONTAIN_ALL = "ands=";
    static final String PM_CONTAIN_EXACT = "phrase=";
    static final String PM_CONTAIN_ANY = "ors=";
    static final String PM_CONTAIN_NONE = "nots=";
    static final String PM_CONTAIN_HASHTAG = "tag=";
    static final String PM_REFERENCE = "ref=";
    static final String PM_SINCE = "since=";
    static final String PM_SOURCE = "source=";
    static final String PM_TO = "to=";
    static final String PM_UNTIL = "until=";
    static final String PM_LANG = "lang=";
    static final String PM_RPP = "rpp=";
    static final String PM_PAGE = "page=";
    static final String PM_SINCE_ID = "since_id=";
    static final String PM_GEOCODE = "geocode=";
    static final String PM_COUNT = "count=";
    static final String PM_MAX_ID = "max_id=";

    public static Query append(Query q1, Query q2) {
        if (q1 == null || q2 == null) {
            throw new IllegalArgumentException("Q1/Q2 must not be null.");
        }
        return new Query(q1.toString() + '&' + q2.toString());
    }

    public static Query containAll(String words) {
        return new Query(PM_CONTAIN_ALL + words);
    }

    public static Query containExact(String phrase) {
        return new Query(PM_CONTAIN_EXACT + phrase);
    }

    public static Query containAny(String words) {
        return new Query(PM_CONTAIN_ANY + words);
    }

    public static Query containNone(String words) {
        return new Query(PM_CONTAIN_NONE + words);
    }

    public static Query containHashtag(String tag) {
        return new Query(PM_CONTAIN_HASHTAG + tag);
    }

    public static Query from(String person) {
        return new Query(PM_FROM + person);
    }

    public static Query reference(String person) {
        return new Query(PM_REFERENCE + person);
    }

    public static Query to(String person) {
        return new Query(PM_TO + person);
    }

    public static Query since(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Date must not be null.");
        }
        return new Query(PM_SINCE + QueryComposer.convertDate(date));
    }

    public static Query until(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Date must not be null.");
        }
        return new Query(PM_UNTIL + QueryComposer.convertDate(date));
    }

    public static Query sinceID(String id) {
        return new Query(PM_SINCE_ID + id);
    }

    public static Query maxID(String id) {
        return new Query(PM_MAX_ID + id);
    }

    public static Query lang(String lang) {
        return new Query(PM_LANG + lang);
    }

    public static Query source(String appName) {
        return new Query(PM_SOURCE + appName);
    }

    public static Query resultCount(int count) {
        return new Query(PM_RPP + count);
    }

    public static Query count(int count) {
        return new Query(PM_COUNT + count);
    }

    public static Query page(int number) {
        return new Query(PM_PAGE + number);
    }

    public static Query paginate(int resultCount, int pageNumber) {
        return QueryComposer.append(QueryComposer.resultCount(resultCount), QueryComposer.page(pageNumber));
    }

    public static Query geocode(String lat, String lon, int rad, String unit) {
        return new Query(PM_GEOCODE + lat + ',' + lon + ',' + rad + unit);
    }

    public static Query positiveAttitude() {
        return new Query(PM_POSITIVE_ATTITUDE);
    }

    public static Query negativeAttitude() {
        return new Query(PM_NEGATIVE_ATTITUDE);
    }

    public static Query containLink() {
        return new Query(PM_FILTER_LINKS);
    }

    public static Query containQuestion() {
        return new Query(PM_ASKING_QUESTION);
    }

    private static String convertDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1) + "-" + (c.get(2) + 1) + "-" + c.get(5);
    }

    private QueryComposer() {
    }
}

