/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.io.HttpResponseCodeInterpreter;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserException;
import com.twitterapime.parser.ParserFactory;
import com.twitterapime.rest.GeoLocation;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.UserAccountManager;
import com.twitterapime.rest.handler.DirectMessageHandler;
import com.twitterapime.rest.handler.StatusHandler;
import com.twitterapime.search.LimitExceededException;
import com.twitterapime.search.Tweet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class TweetER {
    private static final Hashtable SERVICES_URL = new Hashtable(4);
    private static Hashtable tweetERPool;
    private static TweetER singleInstance;
    public static final String TWITTER_API_URL_SERVICE_STATUSES_UPDATE = "TWITTER_API_URL_SERVICE_STATUSES_UPDATE";
    public static final String TWITTER_API_URL_SERVICE_STATUSES_SHOW = "TWITTER_API_URL_SERVICE_STATUSES_SHOW";
    public static final String TWITTER_API_URL_SERVICE_STATUSES_RETWEET = "TWITTER_API_URL_SERVICE_STATUSES_RETWEET";
    public static final String TWITTER_API_URL_SERVICE_DIRECT_MESSAGES_NEW = "TWITTER_API_URL_SERVICE_DIRECT_MESSAGES_NEW";
    private UserAccountManager userAccountMngr;

    private String getURL(String serviceKey) {
        return (String)SERVICES_URL.get(serviceKey);
    }

    static synchronized void cleanPool() {
        if (tweetERPool != null) {
            Enumeration keys = tweetERPool.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                TweetER value = (TweetER)tweetERPool.get(key);
                if (value.userAccountMngr.isVerified()) continue;
                tweetERPool.remove(key);
            }
        }
    }

    public void setServiceURL(String serviceKey, String url) {
        SERVICES_URL.put(serviceKey, url);
    }

    public static synchronized TweetER getInstance(UserAccountManager uam) {
        TweetER ter;
        if (uam == null) {
            throw new IllegalArgumentException("UserAccountManager must not be null.");
        }
        if (!uam.isVerified()) {
            throw new SecurityException("User's credential must be verified.");
        }
        if (tweetERPool == null) {
            tweetERPool = new Hashtable();
        }
        if ((ter = (TweetER)tweetERPool.get(uam)) == null) {
            ter = new TweetER(uam);
            tweetERPool.put(uam, ter);
        }
        return ter;
    }

    public static synchronized TweetER getInstance() {
        if (singleInstance == null) {
            singleInstance = new TweetER();
        }
        return singleInstance;
    }

    private TweetER() {
    }

    private TweetER(UserAccountManager uam) {
        this.userAccountMngr = uam;
    }

    public Tweet findByID(String id) throws LimitExceededException, IOException {
        HttpRequest req;
        if (id == null || (id = id.trim()).length() == 0) {
            throw new IllegalArgumentException("ID must not be empty/null.");
        }
        String url = this.getURL(TWITTER_API_URL_SERVICE_STATUSES_SHOW) + "?id=" + id;
        if (this.userAccountMngr != null) {
            this.checkUserAuth();
            req = this.userAccountMngr.createRequest(url);
        } else {
            req = new HttpRequest(url);
        }
        try {
            HttpResponse resp = req.send();
            if (resp.getCode() == 403) {
                throw new SecurityException();
            }
            if (resp.getCode() == 404) {
                Tweet tweet = null;
                return tweet;
            }
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            StatusHandler handler = new StatusHandler();
            parser.parse(resp.getStream(), handler);
            Tweet tweet = handler.getParsedTweet();
            return tweet;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public Tweet post(Tweet tweet) throws IOException, LimitExceededException {
        if (tweet == null) {
            throw new IllegalArgumentException("Tweet must not be null.");
        }
        tweet.validateContent();
        this.checkUserAuth();
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_STATUSES_UPDATE));
        req.setMethod("POST");
        req.setBodyParameter("status", tweet.getString("TWEET_CONTENT"));
        GeoLocation location = tweet.getLocation();
        if (location != null) {
            String lat = location.getString("GEOLOCATION_LATITUDE");
            String lon = location.getString("GEOLOCATION_LONGITUDE");
            String pid = location.getString("GEOLOCATION_PLACE_ID");
            if (lat != null && lon != null) {
                req.setBodyParameter("lat", lat);
                req.setBodyParameter("long", lon);
                req.setBodyParameter("display_coordinates", "true");
            } else if (pid != null) {
                req.setBodyParameter("place_id", pid);
                req.setBodyParameter("display_coordinates", "true");
            }
        }
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            StatusHandler handler = new StatusHandler();
            parser.parse(resp.getStream(), handler);
            handler.loadParsedTweet(tweet);
            Tweet tweet2 = tweet;
            return tweet2;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public Tweet repost(Tweet tweet) throws IOException, LimitExceededException {
        if (tweet == null) {
            throw new IllegalArgumentException("Tweet must not be null.");
        }
        String id = tweet.getString("TWEET_ID");
        if (id == null || (id = id.trim()).length() == 0) {
            throw new IllegalArgumentException("Tweet ID must not be empty/null.");
        }
        this.checkUserAuth();
        String url = this.getURL(TWITTER_API_URL_SERVICE_STATUSES_RETWEET) + id + ".xml";
        HttpRequest req = this.userAccountMngr.createRequest(url);
        req.setMethod("POST");
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            StatusHandler handler = new StatusHandler();
            parser.parse(resp.getStream(), handler);
            handler.loadParsedTweet(tweet);
            Tweet tweet2 = tweet;
            return tweet2;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public Tweet send(Tweet dm) throws IOException, LimitExceededException {
        UserAccount ua;
        if (dm == null) {
            throw new IllegalArgumentException("DM must not be null.");
        }
        dm.validateRecipient();
        dm.validateContent();
        this.checkUserAuth();
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_DIRECT_MESSAGES_NEW));
        req.setMethod("POST");
        String recipient = dm.getString("TWEET_AUTHOR_USERNAME");
        if (recipient == null && (recipient = (ua = dm.getUserAccount()).getString("USERACCOUNT_ID")) == null) {
            recipient = ua.getString("USERACCOUNT_USER_NAME");
        }
        req.setBodyParameter("user", recipient);
        req.setBodyParameter("text", dm.getString("TWEET_CONTENT"));
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            DirectMessageHandler handler = new DirectMessageHandler();
            parser.parse(resp.getStream(), handler);
            handler.loadParsedTweet(dm, 0);
            Tweet tweet = dm;
            return tweet;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    private void checkUserAuth() {
        if (this.userAccountMngr == null || !this.userAccountMngr.isVerified()) {
            throw new SecurityException("User's credential must be entered to perform this operation.");
        }
    }

    static {
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_UPDATE, "http://api.twitter.com/1/statuses/update.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_SHOW, "http://api.twitter.com/1/statuses/show.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_RETWEET, "http://api.twitter.com/1/statuses/retweet/");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_DIRECT_MESSAGES_NEW, "http://api.twitter.com/1/direct_messages/new.xml");
    }
}

