/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.io;

import com.twitterapime.io.HttpConnection;
import com.twitterapime.io.HttpConnector;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.util.StringUtil;
import com.twitterapime.xauth.Token;
import com.twitterapime.xauth.XAuthSigner;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class HttpRequest {
    private String url;
    private String method;
    private Hashtable bodyParams;
    private Hashtable headers;
    private HttpConnection conn;
    private XAuthSigner signer;
    private Token token;

    public HttpRequest(String url) {
        if (url == null || (url = url.trim()).length() == 0) {
            throw new IllegalArgumentException("URL must not be empty/null");
        }
        this.url = url;
        this.method = "GET";
        this.bodyParams = new Hashtable();
        this.headers = new Hashtable();
    }

    public HttpResponse send() throws IOException {
        this.close();
        String nurl = this.getSanitizedURL();
        if (this.getQueryString() != null) {
            nurl = nurl + '?' + this.queryString(this.getQueryStringParams());
        }
        this.conn = HttpConnector.open(nurl);
        this.conn.setRequestMethod(this.method);
        if (this.signer != null && this.token != null) {
            this.signer.sign(this, this.token);
        }
        this.setHeaderFields(this.conn);
        if ("POST".equals(this.method)) {
            this.setBodyParameters(this.conn);
        }
        return new HttpResponse(this.conn);
    }

    public void close() throws IOException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public void setHeaderField(String key, String value) {
        this.headers.put(key, value);
    }

    public void setBodyParameter(String key, String value) {
        this.bodyParams.put(key, value);
    }

    public Hashtable getHeaderFields() {
        return this.headers;
    }

    public void setMethod(String method) {
        if (!"GET".equals(method) && !"POST".equals(method)) {
            throw new IllegalArgumentException("Invalid Http method: " + method);
        }
        this.method = method;
    }

    public Hashtable getBodyParameters() {
        return this.bodyParams;
    }

    public Hashtable getQueryStringParams() {
        Hashtable<String, String> params = new Hashtable<String, String>();
        String query = this.getQueryString();
        if (query != null) {
            String[] ps = StringUtil.split(query, '&');
            for (int i = 0; i < ps.length; ++i) {
                String[] pv = StringUtil.split(ps[i], '=');
                params.put(pv[0], pv[1]);
            }
        }
        return params;
    }

    public String getURL() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public String getSanitizedURL() {
        int i = this.url.indexOf(63);
        return i != -1 ? this.url.substring(0, i) : this.url;
    }

    public String getQueryString() {
        int i = this.url.indexOf(63);
        return i != -1 ? this.url.substring(i + 1, this.url.length()) : null;
    }

    public void setSigner(XAuthSigner signer, Token token) {
        this.signer = signer;
        this.token = token;
    }

    private void setHeaderFields(HttpConnection conn) throws IOException {
        Enumeration keys = this.headers.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            conn.setRequestProperty(key, (String)this.headers.get(key));
        }
    }

    private void setBodyParameters(HttpConnection conn) throws IOException {
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        if (this.bodyParams.size() > 0) {
            byte[] content = this.queryString(this.bodyParams).getBytes("UTF-8");
            conn.setRequestProperty("Content-Length", String.valueOf(content.length));
            OutputStream out = conn.openOutputStream();
            out.write(content);
            out.flush();
            out.close();
        }
    }

    private String queryString(Hashtable p) {
        StringBuffer queryStr = new StringBuffer();
        Enumeration keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            queryStr.append(StringUtil.encode(key, "UTF-8"));
            queryStr.append('=');
            queryStr.append(StringUtil.encode((String)p.get(key), "UTF-8"));
            if (!keys.hasMoreElements()) continue;
            queryStr.append('&');
        }
        return queryStr.toString();
    }
}

