/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.xauth.encoders;

import com.twitterapime.xauth.encoders.SHA1;
import java.io.UnsupportedEncodingException;

public class HMAC {
    public static byte[] getHmac(String data, String key) {
        try {
            int i;
            byte[] temp;
            byte[] ipadArray = new byte[64];
            byte[] opadArray = new byte[64];
            byte[] keyArray = new byte[64];
            int ex = key.length();
            SHA1 sha1 = new SHA1();
            if (key.length() > 64) {
                temp = sha1.getDigestOfBytes(key.getBytes("UTF-8"));
                ex = temp.length;
                for (i = 0; i < ex; ++i) {
                    keyArray[i] = temp[i];
                }
            } else {
                temp = key.getBytes();
                for (i = 0; i < temp.length; ++i) {
                    keyArray[i] = temp[i];
                }
            }
            for (int i2 = ex; i2 < 64; ++i2) {
                keyArray[i2] = 0;
            }
            for (int j = 0; j < 64; ++j) {
                ipadArray[j] = (byte)(keyArray[j] ^ 0x36);
                opadArray[j] = (byte)(keyArray[j] ^ 0x5C);
            }
            byte[] tempResult = sha1.getDigestOfBytes(HMAC.join(ipadArray, data.getBytes("UTF-8")));
            return sha1.getDigestOfBytes(HMAC.join(opadArray, tempResult));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static byte[] join(byte[] b1, byte[] b2) {
        int i;
        int length = b1.length + b2.length;
        byte[] newer = new byte[length];
        for (i = 0; i < b1.length; ++i) {
            newer[i] = b1[i];
        }
        for (i = 0; i < b2.length; ++i) {
            newer[i + b1.length] = b2[i];
        }
        return newer;
    }

    private HMAC() {
    }
}

