package bigs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigInt implements Cloneable, Comparable<BigInt>, Externalizable, IType<BigInt> {

    private final BigInteger bi;

    public BigInt(BigInteger bi) {
        this.bi = bi;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BigInt bigInt = (BigInt) o;
        return bi != null ? bi.equals(bigInt.bi) : bigInt.bi == null;
    }

    @Override
    public int hashCode() {
        return bi != null ? bi.hashCode() : 0;
    }

    @Override
    public String toString() {
        return bi.toString();
    }

    @Override
    public BigInt clone() {
        return new BigInt(bi);
    }

    @Override
    public int compareTo(BigInt o) {
        return bi.compareTo(o.getBi());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(getBi());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readObject();
    }

    public BigInteger getBi() {
        return bi;
    }

    public BigDec toBigDec() {
        return new BigDec(new BigDecimal(getBi()));
    }

    @Override
    public BigInt zero() {
        return new BigInt(BigInteger.ZERO);
    }

    @Override
    public BigInt one() {
        return new BigInt(BigInteger.ONE);
    }

    @Override
    public BigInt add(BigInt y) {
        return new BigInt(getBi().add(y.getBi()));
    }

    public static BigInt add(BigInt x, BigInt y) {
        return new BigInt(x.getBi().add(y.getBi()));
    }

    @Override
    public BigInt sub(BigInt y) {
        return new BigInt(getBi().subtract(y.getBi()));
    }

    public static BigInt sub(BigInt x, BigInt y) {
        return new BigInt(x.getBi().subtract(y.getBi()));
    }

    @Override
    public BigInt mult(BigInt y) {
        return new BigInt(getBi().multiply(y.getBi()));
    }

    public static BigInt mult(BigInt x, BigInt y) {
        return new BigInt(x.getBi().multiply(y.getBi()));
    }

    @Override
    public BigInt div(BigInt y) {
        return new BigInt(getBi().divide(y.getBi()));
    }

    public static BigInt div(BigInt x, BigInt y) {
        return new BigInt(x.getBi().divide(y.getBi()));
    }

    public BigInt neg() {
        return new BigInt(getBi().negate());
    }

    @Override
    public BigInt pow(int exp) {
        return new BigInt(getBi().pow(exp));
    }

}
