package math.primes;

import javax.swing.*;
import java.awt.*;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;

enum Ksztalt {
    KOLO, KWADRAT
}

class SitoErastotenesa extends JPanel {
    private static final long serialVersionUID = 6849391892934979390L;
    private final int liczbaPol = 25;
    private final boolean[] primes1;//komorki aktualne
    private final Timer timer;
    private final int milis;
    private final int n;
    private int k;
    private final int nn;

    public SitoErastotenesa(int milis) {
        setPreferredSize(new Dimension(800, 800));
        setBackground(Color.WHITE);
        this.milis = milis;
        this.n = liczbaPol * liczbaPol;
        this.k = 2;
        this.nn = (int) Math.floor(Math.sqrt(n));
        primes1 = new boolean[n + 1];
        //primes2 = new boolean[n + 1];
        Arrays.fill(primes1, true);
        primes1[0] = false;
        primes1[1] = false;
        timer = new Timer();
        TimerTask timerTask = new TimerTask() {
            @Override
            public void run() {
                if (k <= nn) {
                    for (int i = 2 * k; i < n + 1; i = i + k) {
                        primes1[i] = false;
                    }
                    for (int j = k + 1; j < n + 1; j++) {
                        if (primes1[j]) {
                            k = j;
                            break;
                        }
                    }
                    repaint();
                } else {
                    timer.cancel();
                }
            }
        };
        timer.schedule(timerTask, 500, milis);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setColor(Color.WHITE);
        g2.clearRect(0, 0, 800, 800);
        g2.setColor(Color.LIGHT_GRAY);
        int z = 0;//polozenie linii
        int szer = 32;//odleglosc miedzy liniami = szerokosc komorki
        int len = szer * liczbaPol;
        for (int i = 0; i <= liczbaPol + 1; i++) {
            g2.drawLine(0, z, len, z);
            g2.drawLine(z, 0, z, len);
            z += szer;
        }
        g2.setColor(Color.BLACK);
        for (int i = 0; i < primes1.length; i++) {
            int[] t = ArrayUtil.obliczRowCol(i, liczbaPol);
            int x = t[0] * szer;
            int y = t[1] * szer;
            if (primes1[i]) {
                g2.setColor(Color.BLACK);
                g2.drawString(String.valueOf(i), y + 7, x + 20);
            } else {
                g2.setColor(Color.GRAY);
                g2.fillRect(y + 1, x + 1, szer - 2, szer - 2);
            }
        }
    }

    public int getMilis() {
        return milis;
    }
}
