package rozdzial31;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;

import java.net.URL;

public class Listing31_05 extends Application {

    private Alert conf;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            WebView wv = new WebView();
            WebEngine we = wv.getEngine();
            URL url = this.getClass().getClassLoader().getResource("src/resources/html/confirm.html");
            if (url != null) {
                we.load(url.toExternalForm());
            }
            we.setConfirmHandler(new Callback<String, Boolean>() {
                @Override
                public Boolean call(String param) {
                    conf = new Alert(Alert.AlertType.CONFIRMATION);
                    conf.setTitle("Potwierdź");
                    conf.setHeaderText(param);
                    conf.setContentText("OK - jeśli chcesz\nCANCEL - jeśli nie chcesz");
                    conf.initOwner(stage);
                    return conf.showAndWait().isPresent() && (conf.showAndWait().get() == ButtonType.OK);
                }
            });
            root.getChildren().add(wv);
            Scene scene = new Scene(root, 560, 360);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
