package rozdzial26;

import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.media.Track;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import rozdzial24.IOUtil;

import java.net.URL;
import java.util.Map;

public class Listing26_05 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            URL url = IOUtil.fileToURL("src/resources/assets/ziggurat.mp4");
            VBox root = new VBox();
            Media media = new Media(url.toString());
            MediaPlayer mp = new MediaPlayer(media);
            mp.setAutoPlay(false);
            MediaView mv = new MediaView(mp);
            Text text = new Text("\"Wieża Babel\"");
            Text text1 = new Text("Animacja: Anna Szpakowska");
            Text text2 = new Text("Freski w Świątyni: Maciej Krzywicki");
            Button start = new Button("Start");
            start.setOnAction(e -> {
                mp.play();
                System.out.println("Czas trwania utworu: "
                        + media.getDuration().toSeconds() + "s.");
                System.out.println("width: " + media.getWidth() + ", height: "
                        + media.getHeight());
                ObservableList<Track> tracks = media.getTracks();
                System.out.println("size: " + tracks.size());
                Track track1 = tracks.get(0);
                System.out.println("name: " + track1.getName());
                System.out.println("ID: " + track1.getTrackID());
                System.out.println("Locale: " + track1.getLocale());
                Map<String, Object> meta = track1.getMetadata();
                for (String key : meta.keySet()) {
                    System.out.println(key + ": " + meta.get(key));
                }
            });
            Button pause = new Button("Pauza");
            pause.setOnAction(e -> mp.pause());
            Button stop = new Button("Stop");
            stop.setOnAction(e -> mp.stop());
            HBox hbox = new HBox();
            hbox.getChildren().addAll(start, pause, stop);
            root.getChildren().addAll(text, text1, text2, mv, hbox);
            Scene scene = new Scene(root, 800, 500);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
