package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.MotionBlur;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class Listing13_06 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            Text text = new Text("Shadow");
            text.setX(220);
            text.setY(100);
            text.setFill(Color.BLACK);
            //text.setStroke(Color.BLACK);
            text.setFont(Font.font(null, FontWeight.BOLD, 80));
            //efekt
            MotionBlur ds = new MotionBlur();
            text.setEffect(ds);
            //slider 2
            Slider oyslider = new Slider(0, 63, 30);
            oyslider.setLayoutX(60);
            oyslider.setLayoutY(60);
            oyslider.setMajorTickUnit(10);
            oyslider.setShowTickLabels(true);
            oyslider.setShowTickMarks(true);
            ds.radiusProperty().bind(oyslider.valueProperty());
            Label oyslabel = new Label("radius: ");
            oyslabel.setLabelFor(oyslider);
            oyslabel.setLayoutX(20);
            oyslabel.setLayoutY(60);
            //slider 3
            Slider cslider = new Slider(-360, 360, -15);
            cslider.setLayoutX(60);
            cslider.setLayoutY(100);
            cslider.setMajorTickUnit(120);
            cslider.setShowTickLabels(true);
            cslider.setShowTickMarks(true);
            ds.angleProperty().bind(cslider.valueProperty());
            Label slabel = new Label("angle: ");
            slabel.setLabelFor(cslider);
            slabel.setLayoutX(20);
            slabel.setLayoutY(100);
            //
            root.getChildren().addAll(oyslabel, oyslider, cslider, slabel,
                    text);
            Scene scene = new Scene(root, 560, 280);
            scene.setFill(Color.WHITE);
            stage.setScene(scene);
            stage.setTitle("MotionBlur");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
