package math.utils;

public class Tuple2L {
    private long x;
    private long y;

    public Tuple2L() {
        this(0L, 0L);
    }

    public Tuple2L(long x, long y) {
        this.x = x;
        this.y = y;
    }

    public double distance(Tuple2L tuple) {
        return Math.sqrt(x * tuple.getX() + y * tuple.getY());
    }

    @Override
    public String toString() {
        return "[" + x + ", " + y + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof Tuple2L)) {
            return false;
        }
        Tuple2L t2 = (Tuple2L) obj;
        return (x == t2.getX()) && (y == t2.getY());
    }

    @Override
    public int hashCode() {
        return 17 * Long.valueOf(x).hashCode() + 19 * Long.valueOf(y).hashCode();
    }

    public long getX() {
        return x;
    }

    public void setX(long x) {
        this.x = x;
    }

    public long getY() {
        return y;
    }

    public void setY(long y) {
        this.y = y;
    }
}
