package rozdzial28;

import javafx.application.Application;
import javafx.concurrent.ScheduledService;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Listing28_11 extends Application {
    private Label label;
    ScheduledService<String> lottoService;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            lottoService = new LottoScheduledService();
            lottoService.setDelay(Duration.seconds(1));
            lottoService.setPeriod(Duration.seconds(2));
            lottoService.setMaximumFailureCount(5);
            lottoService.setOnSucceeded(e -> label.setText("lotto: " + lottoService.getValue()));
            VBox vbox = new VBox();
            HBox hbox = new HBox();
            Scene scene = new Scene(vbox, 200, 200);
            label = new Label("Kliknij przycisk 'Losuj'");
            Button start = new Button("Losuj");
            //start.setOnAction(e -> task());
            start.setOnAction(event -> lottoService.start());
            Button end = new Button("Zakończ");
            end.setOnAction(e -> stage.close());
            hbox.setSpacing(5);
            hbox.getChildren().addAll(start, end);
            vbox.setSpacing(150);
            vbox.getChildren().addAll(label, hbox);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
