package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.Light;
import javafx.scene.effect.Lighting;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class Listing13_20 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Light l3 = new Light.Spot(100, 100, 100, 1.0, Color.BISQUE);
            Pane root = new Pane();
            Text text = new Text("Suitka");
            text.setX(220);
            text.setY(100);
            text.setFill(Color.AQUAMARINE);
            text.setFont(Font.font(null, FontWeight.BOLD, 80));
            //efekt
            Lighting ds = new Lighting(l3);
            text.setEffect(ds);
            //slider 1
            Slider oxslider = new Slider(0.0, 2.0, 1.0);
            oxslider.setLayoutX(60);
            oxslider.setLayoutY(40);
            oxslider.setMajorTickUnit(0.4);
            oxslider.setShowTickLabels(true);
            oxslider.setShowTickMarks(true);
            ds.diffuseConstantProperty().bind(oxslider.valueProperty());
            Label oxslabel = new Label("diffuseConstant: ");
            oxslabel.setLabelFor(oxslider);
            oxslabel.setLayoutX(20);
            oxslabel.setLayoutY(20);
            //slider 2
            Slider oyslider = new Slider(0.0, 2.0, 0.3);
            oyslider.setLayoutX(60);
            oyslider.setLayoutY(110);
            oyslider.setMajorTickUnit(0.4);
            oyslider.setShowTickLabels(true);
            oyslider.setShowTickMarks(true);
            ds.specularConstantProperty().bind(oyslider.valueProperty());
            Label oyslabel = new Label("speculatConstant: ");
            oyslabel.setLabelFor(oyslider);
            oyslabel.setLayoutX(20);
            oyslabel.setLayoutY(90);
            //slider 3
            Slider cslider = new Slider(0.0, 40.0, 20);
            cslider.setLayoutX(60);
            cslider.setLayoutY(180);
            cslider.setMajorTickUnit(10);
            cslider.setShowTickLabels(true);
            cslider.setShowTickMarks(true);
            ds.specularExponentProperty().bind(cslider.valueProperty());
            Label slabel = new Label("specularExponent: ");
            slabel.setLabelFor(cslider);
            slabel.setLayoutX(20);
            slabel.setLayoutY(160);
            //slider 4
            Slider rslider = new Slider(0.0, 10.0, 1.5);
            rslider.setLayoutX(60);
            rslider.setLayoutY(250);
            rslider.setMajorTickUnit(1);
            rslider.setShowTickLabels(true);
            rslider.setShowTickMarks(true);
            ds.surfaceScaleProperty().bind(rslider.valueProperty());
            Label rlabel = new Label("surfaceScale: ");
            rlabel.setLabelFor(rslider);
            rlabel.setLayoutX(20);
            rlabel.setLayoutY(230);
            root.getChildren().addAll(oxslabel, oxslider, oyslabel, oyslider,
                    cslider, slabel, rlabel, rslider, text);
            Scene scene = new Scene(root, 560, 300);
            stage.setScene(scene);
            stage.setTitle("Lighting");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
