package rozdzial27;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import rozdzial24.IOUtil;

import java.io.File;
import java.nio.file.Files;
import java.util.List;

public class Listing27_03 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            //
            Label label = new Label(
                    "Przeciągnij tutaj obrazek albo plik obrazka");
            //
            ImageView iv = new ImageView();
            iv.setFitWidth(380);
            iv.setFitHeight(380);
            //
            Button but = new Button("Usuń obrazek");
            but.setOnAction(e -> {
                iv.setImage(null);
                iv.setFitWidth(380);
                iv.setFitHeight(380);
            });
            root.getChildren().addAll(label, iv, but);
            Scene scene = new Scene(root, 400, 440);
            scene.setOnDragOver(e -> {
                Dragboard dbo = e.getDragboard();
                if (dbo.hasFiles() || dbo.hasImage()) {
                    e.acceptTransferModes(TransferMode.ANY);
                }
                e.consume();
            });
            scene.setOnDragDropped(e -> {
                boolean done = false;
                Dragboard dbo = e.getDragboard();
                if (dbo.hasFiles()) {
                    List<File> files = dbo.getFiles();
                    String mt;
                    try {
                        for (File f : files) {
                            mt = Files.probeContentType(f.toPath());
                            if (mt != null && mt.startsWith("image/")) {
                                String imu = IOUtil.fileToURL(f)
                                        .toExternalForm();
                                Image im = new Image(imu);
                                iv.setFitWidth(im.getWidth());
                                iv.setFitHeight(im.getHeight());
                                iv.setPreserveRatio(true);
                                iv.setSmooth(true);
                                iv.setImage(im);
                                done = true;
                            }
                        }
                    } catch (Exception e1) {
                        System.out.println(e1.getMessage());
                    }
                } else if (dbo.hasImage()) {
                    Image im = dbo.getImage();
                    iv.setFitWidth(im.getWidth());
                    iv.setFitHeight(im.getHeight());
                    iv.setPreserveRatio(true);
                    iv.setSmooth(true);
                    iv.setImage(im);
                    done = true;
                }
                e.setDropCompleted(done);
                e.consume();
            });
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
