package rozdzial26;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.stage.Stage;
import rozdzial24.IOUtil;

import java.net.URL;

public class Listing26_08 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            URL url = IOUtil.fileToURL("src/resources/assets/psy1.mp4");
            VBox root = new VBox();
            Media media = new Media(url.toString());
            MediaPlayer mp = new MediaPlayer(media);
            mp.setAutoPlay(false);
            mp.statusProperty()
                    .addListener((observable, oldValue, newValue) -> System.out.println("Status zmienił się z "
                            + oldValue + " na " + newValue));
            mp.setOnPlaying(() -> System.out.println("Odtwarzanie"));
            mp.setOnPaused(() -> System.out.println("Przerwa w odtwarzaniu"));
            mp.setOnStopped(() -> System.out.println("Koniec odtwarzania"));
            MediaView mv = new MediaView(mp);
            mv.setFitWidth(320);
            mv.setFitHeight(240);
            Button start = new Button("Start");
            start.setOnAction(e -> mp.play());
            Button pause = new Button("Pauza");
            pause.setOnAction(e -> mp.pause());
            Button stop = new Button("Stop");
            stop.setOnAction(e -> mp.stop());
            HBox hbox = new HBox();
            hbox.getChildren().addAll(start, pause, stop);
            root.getChildren().addAll(mv, hbox);
            Scene scene = new Scene(root, 340, 280);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
