package rozdzial26;

import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.*;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import rozdzial24.IOUtil;

import java.net.URL;

public class Listing26_04 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            URL url = IOUtil
                    .fileToURL("src/resources/assets/taniec_smoczat.mp3");
            Media media = new Media(url.toString());
            MediaPlayer mp = new MediaPlayer(media);
            mp.setAutoPlay(false);
            MediaView mv = new MediaView(mp);
            Text text = new Text("\"Taniec smocząt\"");
            AudioEqualizer ae = mp.getAudioEqualizer();
            ObservableList<EqualizerBand> oleb = ae.getBands();
            for (int i = 0; i < oleb.size(); i++) {
                EqualizerBand eb = oleb.get(i);
                System.out.println(eb.getBandwidth() + ", "
                        + eb.getCenterFrequency() + ". " + eb.getGain());
            }
            Button start = new Button("Start");
            start.setOnAction(e -> mp.play());
            Button pause = new Button("Pauza");
            pause.setOnAction(e -> mp.pause());
            Button stop = new Button("Stop");
            stop.setOnAction(e -> mp.stop());
            HBox hbox = new HBox();
            hbox.getChildren().addAll(start, pause, stop);
            root.getChildren().addAll(text, mv, hbox);
            Scene scene = new Scene(root, 300, 200);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
