package rozdzial24;

import javafx.application.Application;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

import javax.imageio.ImageIO;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;

public class Listing24_23 extends Application {
    private static final int w = 560;
    private static final double min = -2.0;
    private static final double max = 2.0;
    private static final double scale = (max - min) / w;
    private static final double s = 2.0;
    private final int liczbaIteracji = 512;
    private final double re = -0.6;
    private final double im = 0.4;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            WritableImage image = new WritableImage(w, w);
            PixelWriter pw = image.getPixelWriter();
            for (int i = 0; i < w; i++) {
                for (int j = 0; j < w; j++) {
                    double zr = min + j * scale;
                    double zi = min + i * scale;
                    int licz = liczIter(zr, zi);
                    int a = 255;
                    int r = licz << 7;
                    int g = licz << 5;
                    int b = licz << 6;
                    pw.setArgb(j, i, IOUtil.ARGBtoInt(a, r, g, b));
                }
            }
            ImageView imageView = new ImageView(image);
            StackPane root = new StackPane();
            root.getChildren().addAll(imageView);
            File file = new File("src/rozdzial24/fraktalJ.png");
            RenderedImage ri = SwingFXUtils.fromFXImage(image, null);
            try {
                ImageIO.write(ri, "png", file);
            } catch (IOException e) {
                e.printStackTrace();
            }
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int liczIter(double zre, double zim) {
        double kwad = 0;
        int licznik = 0;
        while ((kwad < s * s) && (licznik < liczbaIteracji)) {
            double temp = zre * zre - zim * zim + re;
            zim = s * zre * zim + im;
            zre = temp;
            kwad = zim * zim + zre * zre;
            licznik++;
        }
        return liczbaIteracji - licznik;
    }
}
