package rozdzial14;

import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;

public class Listing14_21 extends Application {
    private double radius = 30;
    private Circle circle;

    @Override
    public void start(Stage stage) {
        StackPane root = new StackPane();
        circle = new Circle(radius);
        circle.setFill(Color.DARKCYAN);
        root.getChildren().add(circle);
        AnimationTimer timer = new MyTimer();
        timer.start();
        Scene scene = new Scene(root, 300, 300);
        stage.setTitle("AnimationTimer");
        stage.setScene(scene);
        stage.show();
    }

    private class MyTimer extends AnimationTimer {
        @Override
        public void handle(long now) {
            radius -= 0.5;
            circle.radiusProperty().set(radius);
            if (radius <= 0) {
                radius = 30.0;
                circle.radiusProperty().set(radius);
                stop();
                System.out.println("Animation stopped");
            }
        }
    }

    public static void main(String[] args) {
        Application.launch(args);
    }
}