package rozdzial25;

import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Listing25_13 extends Application {

    private GraphicsContext gc;
    private final double kat = 1.0;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Group root = new Group();
            Canvas canvas = new Canvas(400, 400);
            gc = canvas.getGraphicsContext2D();
            AnimationTimer timer = new JinJangTimer();
            timer.start();
            root.getChildren().add(canvas);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawJinJang(double x, double y, double radius, Paint leftColor,
                             Paint rightColor) {
        gc.translate(x, y);
        gc.rotate(kat);
        gc.translate(-x, -y);
        //prawe półkole - czarne
        gc.save();
        gc.beginPath();
        double startAngle = 270;
        double endAngle = 180;
        gc.arc(x, y, radius, radius, startAngle, endAngle);
        gc.lineTo(x, y);
        gc.closePath();
        gc.setFill(rightColor);
        gc.fill();
        //lewe pólkole - białe
        gc.beginPath();
        double startAngle1 = 90;
        double endAngle1 = 180;
        gc.arc(x, y, radius, radius, startAngle1, endAngle1);
        gc.lineTo(x, y);
        gc.closePath();
        gc.setFill(leftColor);
        gc.fill();
        //górne kółko średnie białe
        gc.beginPath();
        gc.setFill(leftColor);
        gc.arc(x, y - radius / 2, radius / 2.0, radius / 2.0, 0, 360);
        gc.fill();
        //dolne średnie kółko czarne
        gc.beginPath();
        gc.setFill(rightColor);
        gc.arc(x, y + radius / 2, radius / 2.0, radius / 2.0, 0, 360);
        gc.fill();
        //- małe kółko czarne
        gc.beginPath();
        gc.setFill(rightColor);
        gc.arc(x, y - radius / 2, radius / 12.0, radius / 12.0, 0, 360);
        gc.fill();
        //- małe kółko białe
        gc.beginPath();
        gc.setFill(leftColor);
        gc.arc(x, y + radius / 2, radius / 12.0, radius / 12.0, 0, 360);
        gc.fill();
        //-Obwiednia kształtu
        gc.beginPath();
        gc.setStroke(rightColor);
        gc.setLineWidth(0.5);
        gc.arc(x, y, radius, radius, 0, 360);
        gc.stroke();
        gc.restore();
    }

    private class JinJangTimer extends AnimationTimer {
        @Override
        public void handle(long now) {
            drawJinJang(200, 160, 150, Color.WHITE, Color.BLACK);
        }
    }
}
