package rozdzial22;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Naklady {
    private final IntegerProperty rok = new SimpleIntegerProperty(this, "rok");
    private final DoubleProperty oswiata = new SimpleDoubleProperty(this, "oswiata");
    private final DoubleProperty kultura = new SimpleDoubleProperty(this, "kultura");
    private final DoubleProperty zdrowie = new SimpleDoubleProperty(this, "zdrowie");

    public Naklady() {
        this(1900, 0.0, 0.0, 0.0);
    }

    public Naklady(int rok, double oswiata, double kultura, double zdrowie) {
        setRok(rok);
        setOswiata(oswiata);
        setKultura(kultura);
        setZdrowie(zdrowie);
    }

    public final IntegerProperty rokProperty() {
        return rok;
    }

    public final int getRok() {
        return rok.get();
    }

    public final void setRok(int rok) {
        this.rok.set(rok);
    }

    public final DoubleProperty oswiataProperty() {
        return oswiata;
    }

    public final double getOswiata() {
        return oswiata.get();
    }

    public final void setOswiata(double oswiata) {
        this.oswiata.set(oswiata);
    }

    public final DoubleProperty kulturaProperty() {
        return kultura;
    }

    public final double getKultura() {
        return kultura.get();
    }

    public final void setKultura(double kultura) {
        this.kultura.set(kultura);
    }

    public final DoubleProperty zdrowieProperty() {
        return zdrowie;
    }

    public final double getZdrowie() {
        return zdrowie.get();
    }

    public final void setZdrowie(double zdrowie) {
        this.zdrowie.set(zdrowie);
    }

    public static ObservableList<Naklady> wstawDane() {
        ObservableList<Naklady> olist = FXCollections.observableArrayList();
        olist.add(new Naklady(1960, 178.7, 105.4, 18.7));
        olist.add(new Naklady(1961, 158.6, 114.2, 16.3));
        olist.add(new Naklady(1962, 174.7, 142.9, 30.8));
        olist.add(new Naklady(1963, 250.1, 128.1, 34.8));
        olist.add(new Naklady(1964, 479.9, 221.6, 63.0));
        olist.add(new Naklady(1965, 497.3, 199.8, 51.0));
        olist.add(new Naklady(1966, 694.6, 199.3, 50.9));
        olist.add(new Naklady(1967, 639.0, 169.0, 56.0));
        olist.add(new Naklady(1968, 640.1, 189.0, 68.0));
        olist.add(new Naklady(1969, 707.0, 221.0, 74.0));
        olist.add(new Naklady(1970, 702.0, 209.0, 70.0));
        olist.add(new Naklady(1971, 785.0, 228.0, 111.0));
        return olist;
    }
}
