package rozdzial18;

import javafx.application.Application;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Listing18_02 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void init() {
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            Label lab = new Label("Wybierz jedną z możliwości:");
            ToggleGroup tg = new ToggleGroup();

            ToggleButton tb1 = new ToggleButton("Spacer");
            tb1.setToggleGroup(tg);
            //-
            ToggleButton tb2 = new ToggleButton("Kawiarnia");
            tb2.setToggleGroup(tg);
            //-
            ToggleButton tb3 = new ToggleButton("Kino");
            tb3.setToggleGroup(tg);
            ReadOnlyObjectProperty<Toggle> sel = tg.selectedToggleProperty();
            sel.addListener(new ChangeListener<Toggle>() {
                @Override
                public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                    if (newValue != null) {
                        System.out.println("Twój wybór to: "
                                + ((ToggleButton) newValue).getText());
                    } else {
                        System.out.println("Twój wybór to: null. Wybierz inną możliwość");
                    }
                }
            });
            root.getChildren().addAll(lab, tb1, tb2, tb3);
            Scene scene = new Scene(root, 300, 200);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
    }
}
