package rozdzial18;

import javafx.application.Application;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Scene;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class Listing18_01 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void init() {
    }

    @Override
    public void start(Stage stage) {
        try {
            StackPane root = new StackPane();
            ToggleButton tb = new ToggleButton("Włącz nagrywanie");
            BooleanProperty sel = tb.selectedProperty();
            sel.addListener((observable, oldValue, newValue) -> {
                System.out.println("Aktualny stan to: " + newValue);
                tb.setText(newValue ? "Nagrywanie" : "Włącz nagrywanie");
            });
            root.getChildren().add(tb);
            Scene scene = new Scene(root, 300, 200);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
    }
}
