package rozdzial02.observ3;


import java.util.Random;
import java.util.concurrent.Flow.Subscriber;
import java.util.concurrent.Flow.Subscription;
import java.util.concurrent.atomic.AtomicInteger;

public class Centrala implements Subscriber<Komunikat> {

    private Subscription subscription;
    private AtomicInteger count;
    private final String name;
    private int dem = 0;

    public Centrala(String name) {
        this.name = name;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        System.out.println("Tu " + name + " Jestem na nasłuchu ...");
        this.subscription = subscription;
        request(dem);
    }

    public void setDem(int n) {
        this.dem = n;
        count = new AtomicInteger(dem);
    }

    public int getDem() {
        return dem;
    }

    private void request(int n) {
        System.out.println("Żądam " + n + " nowych komunikatów ...");
        subscription.request(n);
    }

    @Override
    public void onNext(Komunikat item) {
        if (count.decrementAndGet() == 0) {
            if (new Random().nextBoolean()) {
                request(dem);
                count.set(dem);
            } else {
                System.out.println("Kończę nasłuch ...");
                subscription.cancel();
            }
        }
    }

    @Override
    public void onComplete() {
        System.out.println("Zakończone!");
    }

    @Override
    public void onError(Throwable t) {
        System.out.println("Błąd: " + t.getMessage());
    }
}