package swarm;

import java.awt.*;
import java.awt.geom.*;

public class Body implements Shape {
    private GeneralPath path;

    public Body(float x, float y, float w, float h) {
        path = new GeneralPath();
        path.moveTo(x, y);
        path.lineTo(x + w / 2f, y + 2f * h / 3f);
        path.lineTo(x + w, y);
        path.moveTo(x + w / 4f, y + h);
        path.lineTo(x + w / 2f, y + 2f * h / 3f);
        path.lineTo(x + 3f / 4f * w, y + h);
    }

    @Override
    public boolean contains(Point2D p) {
        return path.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return path.contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return path.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return path.contains(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return path.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return path.getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return path.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return path.getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return path.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return path.intersects(x, y, w, h);
    }
}
