package math.utils;

import math.fibo.Fibo;

import java.math.BigInteger;
import java.util.ArrayList;

public class FiboUtil {
    private FiboUtil() {
    }

    public static double fi() {
        return (Math.sqrt(5) + 1.0) / 2.0;
    }

    /**
     * Obliczanie liczby fi. 'BigFunctions' to klasa, ktorą można ściągnąć stąd:
     * https://github.com/tareknaj/BigFunctions
     * a której ze względu na prawa autorskie nie moźemy tutaj zamieścić
     * @param scale - skala
     * @return - liczbę fi.
     */
    /**
     public static BigDecimal bigFi(int scale) {
     BigDecimal a = BigFunctions.sqrt(new BigDecimal(5), scale);
     return a.add(BigDecimal.ONE).divide(new BigDecimal(2), RoundingMode.HALF_EVEN);
     }
     */

    /**
     * @param n który wyraz ciagu Fibonnacciego
     * @return liczba Fibonacciego
     */
    public static BigInteger fibonacci(long n) {
        BigInteger[] tabl = {BigInteger.ONE, BigInteger.ONE, BigInteger.ONE,
                BigInteger.ZERO};
        BigInteger[] tablKonc = {BigInteger.ONE, BigInteger.ONE, BigInteger.ONE,
                BigInteger.ZERO};
        if (n == 0) {
            return BigInteger.ZERO;
        }
        if (n == 1) {
            return BigInteger.ONE;
        }
        for (long i = 0; i < n; i++) {
            tablKonc = multi(tablKonc, tabl);
        }
        return tablKonc[3];
    }

    //mnozy dwie macierze 2x2 podane jako tablice int[4];
    public static BigInteger[] multi(BigInteger[] a, BigInteger[] b) {
        BigInteger[] t = new BigInteger[4];
        t[0] = (a[0].multiply(b[0])).add(a[1].multiply(b[2]));
        t[1] = (a[0].multiply(b[1])).add(a[1].multiply(b[3]));
        t[2] = (a[2].multiply(b[0])).add(a[3].multiply(b[2]));
        t[3] = (a[2].multiply(b[1])).add(a[3].multiply(b[3]));
        return t;
    }

    /**
     * @param liczba - pewna liczba
     * @return - najbliższa liczba Fibonnaciego większa od tej liczby
     */
    public static BigInteger biggerFibo(BigInteger liczba) {
        BigInteger[] tabl = {BigInteger.ONE, BigInteger.ONE, BigInteger.ONE,
                BigInteger.ZERO};
        BigInteger[] tablKonc = {BigInteger.ONE, BigInteger.ONE, BigInteger.ONE,
                BigInteger.ZERO};
        boolean b = true;
        while (b) {
            tablKonc = FiboUtil.multi(tablKonc, tabl);
            b = BigsUtil.mniejszy(tablKonc[3], liczba);
        }
        return tablKonc[3];
    }

    public static boolean isFibo(BigInteger liczba) {
        BigInteger[] tabl = {BigInteger.ONE, BigInteger.ONE, BigInteger.ONE,
                BigInteger.ZERO};
        BigInteger[] tablKonc = {BigInteger.ONE, BigInteger.ONE, BigInteger.ONE,
                BigInteger.ZERO};
        boolean b = true;
        while (b) {
            tablKonc = FiboUtil.multi(tablKonc, tabl);
            b = BigsUtil.mniejszy(tablKonc[3], liczba);
        }
        return tablKonc[3].equals(liczba);
    }

    public static int numSumaCyfr(String str) {
        int sum = 0;
        int len = str.length();
        for (int i = 0; i < len; i++) {
            String temp = str.substring(i, i + 1);
            sum += Integer.parseInt(temp);
            if (sum > 9) {
                String temp1 = String.valueOf(sum);
                int i1 = Integer.parseInt(temp1.substring(0, 1));
                int i2 = Integer.parseInt(temp1.substring(1, 2));
                sum = i1 + i2;
            }
        }
        return sum;
    }

    /**
     * @param liczba - pewna liczba
     * @return najbliższa liczba Fibonacciego mniejsza niż ta liczba
     */
    public static BigInteger smallerFibo(BigInteger liczba) {
        BigInteger[] tabl = {BigInteger.ONE, BigInteger.ONE, BigInteger.ONE,
                BigInteger.ZERO};
        BigInteger[] tablKonc = {BigInteger.ONE, BigInteger.ONE, BigInteger.ONE,
                BigInteger.ZERO};
        boolean b = true;
        long i = 0;
        while (b) {
            tablKonc = multi(tablKonc, tabl);
            i++;
            b = BigsUtil.mniejszy(tablKonc[3], liczba);
        }
        return new Fibo(i - 1L).getFibo();
    }

    /**
     * rozklada liczbe na sume liczb Fibonacciego
     *
     * @param liczba do rozlozenia
     * @return arraylista liczb, ktorych suma jest rowna liczbie
     */
    public static ArrayList<BigInteger> rozklad(BigInteger liczba) {
        ArrayList<BigInteger> al = new ArrayList<>();
        if (isFibo(liczba)) {
            al.add(liczba);
            return al;
        }
        BigInteger stara = new BigInteger(liczba.toString());//100,
        boolean a = true;
        while (a) {
            BigInteger smaller = smallerFibo(stara);//89,
            stara = stara.subtract(smaller);//11,
            if (isFibo(stara)) {
                al.add(smaller);
                al.add(stara);
                //return al;
                a = false;
            } else {
                al.add(smaller);
            }
        }
        return al;
    }

    public static ArrayList<BigInteger> getFibos(BigInteger min,
                                                 BigInteger max) {
        ArrayList<BigInteger> list = new ArrayList<>();
        for (BigInteger j = min.add(BigInteger.ONE); BigsUtil.mniejszy(j,
                max); j = j.add(BigInteger.ONE)) {
            if (isFibo(j)) {
                list.add(j);
            }
        }
        return list;
    }

    /**
     * Określa numer liczby w ciągu. Podajemy liczbę
     *
     * @param liczba - liczba
     * @return - numer liczby w ciągu
     */
    public static long numer(long liczba) {
        double x = Math.sqrt(5) * liczba + 0.5;
        return (long) (MathUtil.log(x, fi()));
    }

    /**
     * oblicza n+1 wyraz ciągu Fibonacciego
     *
     * @param n - liczba do obliczenia
     * @return long - obliczony wyraz ciągu
     * wolny i pamieciozerny algorytm
     */
    public static int fibonacci(int n) {
        if (n < 2) {
            return n;
        } else {
            return fibonacci(n - 1) + fibonacci(n - 2);
        }
    }

    public static int fibonacci2(int n) {
        int result = n;
        if (n > 1) {
            int min1 = 0;
            int min2 = 1;
            for (int i = 2; i < n + 1; i++) {
                result = min1 + min2;
                min1 = min2;
                min2 = result;
            }
        } else {
            result = n;
        }
        return result;
    }

    public static int[] fibonacciArray(int n) {
        int[] tabl = new int[n + 1];
        tabl[0] = 0;
        tabl[1] = 1;
        for (int i = 2; i < n + 1; i++) {
            tabl[i] = tabl[i - 1] + tabl[i - 2];
        }
        return tabl;
    }

    /**
     * oblicza wartość ciągu Fibonacciego dla podanej wartości n
     *
     * @param n int - liczba do obliczenia
     * @return int - obliczona wartość
     * bardzo szybki algorytm nie obciazajacy pamieci
     */
    public static int fibonacci3(int n) {
        int[] tabl = {1, 1, 1, 0};
        int[] tablKonc = {1, 1, 1, 0};
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        for (int i = 0; i < n; i++) {
            tablKonc = multi(tablKonc, tabl);
        }
        return tablKonc[3];
    }

    //mnozy dwie macierze 2x2 podane jako tablice int[4];
    private static int[] multi(int[] a, int[] b) {
        int[] t = new int[4];
        t[0] = a[0] * b[0] + a[1] * b[2];
        t[1] = a[0] * b[1] + a[1] * b[3];
        t[2] = a[2] * b[0] + a[3] * b[2];
        t[3] = a[2] * b[1] + a[3] * b[3];
        return t;
    }

    //Binet
    public static double fibonacci4(int n) {
        int i = 5;
        return (int) ((1.0 / Math.sqrt(i)
                * Math.pow((1.0 + Math.sqrt(i)) / 2, n))
                - (1.0 / Math.sqrt(i) * Math.pow((1.0 - Math.sqrt(i)) / 2, n)));
    }
}
