package rozdzial22;

import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Listing22_18 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @SuppressWarnings("unchecked")
    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            ObservableList<Naklady> olist = Naklady.wstawDane();
            TableView<Naklady> tv1 = new TableView<>();
            tv1.setItems(olist);
            TableColumn<Naklady, Integer> rokCol = new TableColumn<>("Rok");
            rokCol.setCellValueFactory(
                    new PropertyValueFactory<>("rok"));
            TableColumn<Naklady, Double> oswiataCol = new TableColumn<>(
                    "Oświata");
            oswiataCol.setCellValueFactory(
                    new PropertyValueFactory<>("oswiata"));
            TableColumn<Naklady, Double> kulturaCol = new TableColumn<>(
                    "Kultura");
            kulturaCol.setCellValueFactory(
                    new PropertyValueFactory<>("kultura"));
            TableColumn<Naklady, Double> zdrowieCol = new TableColumn<>(
                    "Zdrowie");
            zdrowieCol.setCellValueFactory(
                    new PropertyValueFactory<>("zdrowie"));
            tv1.getColumns().setAll(rokCol, oswiataCol, kulturaCol, zdrowieCol);
            tv1.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            tv1.getSelectionModel().setCellSelectionEnabled(true);
            TableView.TableViewFocusModel<Naklady> tf = tv1.getFocusModel();
            tf.focus(3, kulturaCol);
            TablePosition<Naklady, Integer> tp = tf.getFocusedCell();
            int row = tp.getRow();
            int col = tp.getColumn();
            System.out.println("row: " + row + ", col: " + col);
            root.getChildren().add(tv1);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
