package rozdzial10;

import javafx.application.Application;
import javafx.geometry.Point2D;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import javafx.stage.Stage;

public class Listing10_08 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Rectangle rect1 = new Rectangle(70, 70, 100, 60);
            LinearGradient lg1 = new LinearGradient(0, 0, 1, 0, true,
                    CycleMethod.NO_CYCLE, new Stop(0, Color.DODGERBLUE),
                    new Stop(1, Color.BLACK));
            rect1.setFill(lg1);
            double px = 120;
            double py = 105;
            Point2D p1 = new Point2D(px, py);
            double mxx = Math.cos(Math.toRadians(30));
            double mxy = -Math.sin(Math.toRadians(30));
            double myx = Math.sin(Math.toRadians(30));
            double myy = Math.cos(Math.toRadians(30));
            double tx = px - px * mxx + py * myx;
            double ty = py - px * myx - py * mxx;
            Transform t1 = new Affine(mxx, mxy, tx, myx, myy, ty);
            Point2D p2 = t1.transform(p1);
            System.out.println(p2);
            Pane root = new Pane();
            root.getChildren().addAll(rect1);
            Scene scene = new Scene(root, 400, 400);
            stage.setScene(scene);
            stage.setTitle("Scena");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
