package com.corejdo.examples.util;

import java.util.Properties;
import java.io.*;
import javax.jdo.*;

/**
 * @author mccammon
 *
 */
public class PersistenceManagerFactoryHelper {

  // singleton PersistenceManagerFactory 
  private static PersistenceManagerFactory pmf;

  /**
   * <p>Metoda zwraca singleton
   * PersistenceManagerFactory. Jeli singleton 
   * nie zosta jeszcze zainicjowany, to metoda tworzy instancj PersistenceManagerFactory
   * na podstawie pliku wacwoci "jdo.properties"
   * i inicjuje singleton.</p>
   * 
   * @throws JDOFatalUserException jeli wystpi bd podczas
   * tworzenia instancji PersistenceManagerFactory 
   * 
   * @return singleton PersistenceManagerFactory 
   */
  public static PersistenceManagerFactory getPersistenceManagerFactory() {

    if (pmf == null) {

      String filename = System.getProperty("jdo.properties");

      if (filename == null) {

        throw new JDOFatalUserException("Waciwo systemowa 'jdo.properties' nie zostaa zdefiniowana");
      }

      Properties properties = new Properties();

      try {

        FileInputStream file = new FileInputStream(filename);

        properties.load(file);

        file.close();

        pmf = JDOHelper.getPersistenceManagerFactory(properties);
      }

      catch (java.io.IOException e) {

        throw new JDOFatalUserException(
          "Bd podczas odczytu '" + filename + "'",
          e);
      }
    }

    return pmf;
  }
  
  private PersistenceManagerFactoryHelper() {}
}
