package com.corejdo.examples.model;

/**
 * @author mccammon
 * 
 */
public class Address {

  protected String street;
  protected String city;
  protected String zipcode;
  protected String state;

  /**
   * <p>Tworzy instancj klasy Address.</p>
   * 
   * @param street nazwa ulicy i numer
   * @param city nazwa miasta
   * @param zipcode kod pocztowy
   * @param state stan
   */
  public Address(String street, String city, String zipcode, String state) {

    this.street = street;
    this.city = city;
    this.zipcode = zipcode;
    this.state = state;
  }
  
  protected Address() {}

  /**
   * <p>Zwraca ulic.</p>
   * 
   * @return ulica
   */
  public String getStreet() {

    return street;
  }

  /**
   * <p>Okrela ulic.</p>
   * 
   * @param street ulica
   */
  public void setStreet(String street) {

    this.street = street;
  }

  /**
   * <p>Zwraca kod pocztowy.</p>
   * 
   * @return kod pocztowy
   */
  public String getZipcode() {

    return zipcode;
  }

  /**
   * <p>Okrela kod pocztowy.</p>
   * 
   * @param zipcode kod pocztowy
   */
  public void setZipcode(String zipcode) {

    this.zipcode = zipcode;
  }

  /**
   * <p>Zwraca stan.</p>
   * 
   * @return stan
   */
  public String getState() {

    return state;
  }

  /**
   * <p>Okrela stan.</p>
   * 
   * @param state stan
   */
  public void setState(String state) {

    this.state = state;
  }
  
  /**
   * <p>Zwraca miasto.</p>
   * 
   * @return miasto
   */
  public String getCity() {
    
    return city;
  }

  /**
   * <p>Okrela miasto.</p>
   * 
   * @param city miasto
   */
  public void setCity(String city) {
    
    this.city = city;
  }
}
