package com.corejdo.examples.chapter7;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

import javax.jdo.Query;
import java.util.Iterator;
import java.util.Collection;
import java.io.ObjectOutputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.FileInputStream;
import javax.jdo.*;

public class TemplateExample {

    public static void main(String args[]) {

        // Plik waciwoci zawiera wszystkie waciwoci konfiguracji
        PersistenceManagerFactory pmf =
                PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

        PersistenceManager pm = pmf.getPersistenceManager();
// tworzy i serializuje zapytanie
        if (args[0].equalsIgnoreCase("serialize")) {
            String filter = "books.contains(myfavouritebook) && " +
                    "(myfavouritebook.title==\"Learn Java Today\")";
            Query query = pm.newQuery(Author.class, filter);
            query.declareVariables("Book myfavouritebook");
            // zamyka zasoby (na wszelki wypadek)
            query.closeAll();
            serializeQuery(query);
        } else if (args[0].equalsIgnoreCase("deserialize")) {


            // deserializuje i wykonuje

            Transaction tx = pm.currentTransaction();


            tx.begin();
            Object deserQuery = deserializeQuery();
            Query recreatedQuery = pm.newQuery(deserQuery);


            Collection results = (Collection) recreatedQuery.execute();
            if (results.isEmpty())
                System.out.println("Brak wyniku");
            else {

                Iterator iter = results.iterator();
                while (iter.hasNext()) {
                    Author author = (Author) iter.next();
                    String name = author.getName();
                    System.out.println("Nazwisko autora: " + name);
                    System.out.println("Adres autora: " + author.getAddress());
                    System.out.println("Wydane ksiki: " );
                    Iterator books = author.getBooks().iterator();
                    while (books.hasNext())
                        System.out.println("Tytu:" + books.next());

                }
            }
            recreatedQuery.closeAll();


            tx.commit();
        }

    }


    /** Serializuje i zapisuje zapytanie
     *
     * @param query obiekt zapytania zapisywany w pliku "query.ser"
     */

    public static void serializeQuery(Query query) {
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream("query.ser"));
            os.writeObject(query);
            os.close();
        } catch (Exception e) {
            System.out.println("Wyjtek podczas serializacji zapytania:" + e);
        }

    }

    /** Deserializuje zapytanie
     *
     * @return  obiekt zapytania odczytany z pliku "query.ser"
     */
    public static Query deserializeQuery() {
        try {
            ObjectInputStream os = new ObjectInputStream(new FileInputStream("query.ser"));
            Query q = (Query) os.readObject();
            os.close();
            return q;
        } catch (Exception e) {
            System.out.println("Wyjtek podczas deserializacji zapytania:" + e);
            return null;
        }

    }
}
