package com.corejdo.examples.chapter7;

import com.corejdo.examples.util.PersistenceManagerFactoryHelper;
import com.corejdo.examples.model.Author;

import javax.jdo.PersistenceManagerFactory;
import javax.jdo.PersistenceManager;
import javax.jdo.Transaction;
import javax.jdo.Query;
import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;

public class SimpleQueryWithFilterAndCandidates {


    public static void main(String agrs[]) {

        // Plik waciwoci zawiera wszystkie waciwoci konfiguracji

        PersistenceManagerFactory pmf =
                PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

        PersistenceManager pm = pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();


        tx.begin();

        Author a1= new Author("Author Smith");
        Author a2= new Author("Autho Jones");
        Author a3= new Author("Author Knowles");
        Collection candidates = new ArrayList();
        candidates.add(a1);
        candidates.add(a2);
        candidates.add(a3);
        pm.makePersistentAll(candidates);

        // wyszukuje autorw, dla ktrych pole name posiada warto "Snoop Smith"
        String filter = "name==\"Author Smith\" ";
        Query query = pm.newQuery(Author.class, filter);
        query.setCandidates(candidates);
        Collection results = (Collection) query.execute();
        if (results.isEmpty())
            System.out.println("Brak wyniku");
        else {

            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Author author = (Author) iter.next();
                String name = author.getName();
                System.out.println("Nazwisko autora: " + name);
                System.out.println("Adres autora: " + author.getAddress());
                System.out.println("Wydane ksiki: " );
                Iterator books=author.getBooks().iterator();
                    while(books.hasNext())
                            System.out.println("Tytu:" +books.next()) ;

            }
        }
        query.closeAll();
        tx.commit();

    }
}
