package com.corejdo.examples.chapter5;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 *
 */
public class TransientTransactionalExample {

 /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw w  wierszu polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Author author = new Author("Keiron McCammon");
    
    System.out.println("Instancja staa si transakcyjna.");
    
    pm.makeTransactional(author);
    
    Transaction tx = pm.currentTransaction();
    
    tx.begin();
    
    System.out.println("Nazwisko autora: '" + author.getName() + "'");
    
    author.setName("Sameer Tyagi");
    
    System.out.println("Nazwisko po modyfikacji: '" + author.getName() + "'");
    
    tx.rollback();
    
    System.out.println(
      "Nazwisko po odwoaniu transakcji: '" + author.getName() + "'");
    
    System.out.println("Instancja staa si nietransakcyjna.");
    
    pm.makeNontransactional(author);
    
    tx.begin();
    
    System.out.println("Nazwisko autora: '" + author.getName() + "'");
    
    author.setName("Sameer Tyagi");
    
    System.out.println("Nazwisko autora po modyfikacji: '" + author.getName() + "'");
    
    tx.rollback();
    
    System.out.println(
      " Nazwisko po odwoaniu transakcji: '" + author.getName() + "'");

    pm.close();
  }
  
  private TransientTransactionalExample() {}
}
