package com.corejdo.examples.chapter5;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 *
 */
public class PersistentTransactionalExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();

    tx.begin();
    
    Author author = new Author("Keiron McCammon");
    
    pm.makePersistent(author);
    
    tx.commit();
    
    System.out.println("Instancja staje si nietransakcyjna.");
    
    pm.makeNontransactional(author);
    
    System.out.println("Nazwisko autora: '" + author.getName() + "'");
    
    author.setName("Sameer Tyagi");
    
    System.out.println("Nazwisko autora po modyfikacji: '" + author.getName() + "'");
    
    tx.begin();
    
    System.out.println("Instancja staje si transakcyjna.");
    
    pm.makeTransactional(author);
    
    System.out.println("Nazwisko autora: '" + author.getName() + "'");
    
    tx.commit();

    pm.close();
  }
  
  private PersistentTransactionalExample() {}
}
