package com.corejdo.examples.chapter3;

import java.util.Collection;

import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 * 
 */
public final class ObjectIdentityExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    /*
     * Pobiera pierwsz instancj PersistenceManager i tworzy now 
     * instancj klasy Author
     */
    PersistenceManager pm1 = pmf.getPersistenceManager();

    Transaction tx1 = pm1.currentTransaction();
    
    tx1.begin();
    
    Author author1 = new Author("Keiron McCammon");
    
    pm1.makePersistent(author1);
    
    tx1.commit();
    
    /*
     * Pobiera drug instancj PersistenceManager, ktrej uywa do pobrania
     * utworzonej wczeniej instancji klasy Author 
     */
    PersistenceManager pm2 = pmf.getPersistenceManager();
        
    Transaction tx2 = pm2.currentTransaction();
    
    tx2.begin();
    
    Query query =
      pm2.newQuery(Author.class, "name == \"Keiron McCammon\"");
    
    Collection authors = (Collection) query.execute();
    
    Author author2 = (Author) authors.iterator().next();
    
    query.close(authors);
    
    tx2.commit();
    
    /*
     * Sprawdza, e instancje znajdujce si w pamici s rnymi 
     * obiektami Java
     */
    if (author1 != author2)
      System.out.println("W pamici znajduje si wiele obiektw");
      
    Object emp1Id = JDOHelper.getObjectId(author1);    
    Object emp2Id = JDOHelper.getObjectId(author2);

    /*
     * Sprawdza, e instancje znajdujce si w pamici reprezentuj
     * ten sam obiekt trway zapisany w bazie danych
     */    
    if (emp1Id.equals(emp2Id))
      System.out.println("Ale reprezentuj one ten sam obiekt trway klasy Author.");
    
    pm1.close();
    pm2.close();
  }
  
  private ObjectIdentityExample() {}
}
