package com.corejdo.examples.chapter3;

import java.util.Properties;

import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;

/**
 * @author mccammon
 *
 */
public final class MakeConnectionFromSystemPropertiesExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    Properties properties = new Properties();
    
    properties.put(
      "javax.jdo.PersistenceManagerFactoryClass",
      System.getProperty("javax.jdo.PersistenceManagerFactoryClass"));
    properties.put(
      "javax.jdo.option.ConnectionURL",
      System.getProperty("javax.jdo.option.ConnectionURL"));
    properties.put(
      "javax.jdo.option.ConnectionUserName",
      System.getProperty("javax.jdo.option.ConnectionUserName"));
    properties.put(
      "javax.jdo.option.ConnectionPassword",
      System.getProperty("javax.jdo.option.ConnectionPassword"));

    try {

      PersistenceManagerFactory pmf =
        JDOHelper.getPersistenceManagerFactory(properties);

      PersistenceManager pm = pmf.getPersistenceManager();

      pm.close();
    } catch (JDOException e) {

      e.printStackTrace();
    }
  }
  
  private MakeConnectionFromSystemPropertiesExample() {}
}
