package com.corejdo.examples.chapter3;

import java.util.Collection;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 * @see com.corejdo.examples.chapter3.CreateExample
 *
 */
public final class DeleteWithRollbackExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry wiersza polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();

    tx.begin();

    Query query = pm.newQuery(Author.class, "name == \"Keiron McCammon\"");

    Collection result = (Collection) query.execute();

    Author author = (Author) result.iterator().next();

    query.close(result);

    pm.deletePersistent(author);

    /*
     * Odwouje transakcj zamiast j zatwierdzi, co anuluje usunicie instancji
     */
    tx.rollback();

    /*
     * Sprawdza, e usunita instancja nadal istnieje w bazie danych.
     */
    tx.begin();

    String name = author.getName();

    System.out.println("Nazwisko autora: '" + name + "'.");

    tx.commit();

    pm.close();
  }
  
  private DeleteWithRollbackExample() {}
}
