package com.corejdo.examples.chapter3;

import java.util.Collection;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 * @see com.corejdo.examples.chapter3.CreateExample
 *
 */
public final class DeleteExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();

    tx.begin();

    Query query = pm.newQuery(Author.class, "name == \"Keiron McCammon\"");

    Collection authors = (Collection) query.execute();

    Author author = (Author) authors.iterator().next();

    pm.deletePersistent(author);

    //query.close(authors);

    tx.commit();

    pm.close();
  }
  
  private DeleteExample() {}
}
