package com.corejdo.casestudy.usecase;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

/**
 * Klasa ta dostarcza pomocniczych metod komponentom JSP umoliwiajcych
 * odnalezienie waciwego kontekstu sesji. Obiekt klasy ServletHelper wie
 * instancj PersistenceManager z kontekstem sesji serwletu.

 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class ServletHelper implements
    HttpSessionBindingListener
{
    private Context context;

    public ServletHelper()
    {
    }

    /**
     * Metoda ta musi zosta wywoana w kodzie JSP, aby powiza
     * kontekst/sesj z danym przypadkiem uycia.
     */
    public synchronized void useBean(AbstractUseCase uc)
    {
        uc.setContext(getContext());
    }

    synchronized Context getContext()
    {
        if (context == null) {
            context = new Context();
        }
        return context;
    }

    public void valueBound(HttpSessionBindingEvent event)
    {
    }

    public static final String NAME = "helper";

    public synchronized void valueUnbound(HttpSessionBindingEvent event)
    {
        if (event.getName().equals(NAME)) {
            if (context != null) {
    System.err.println("Zamknity kontekst sesji "+event.getSession().getId());
                context.close();
                context = null;
            }
        }
    }


    public static String checkBox(String name, boolean isChecked)
    {
        return "<input type=\"checkbox\" name=\""+name+"\" "+
         (isChecked?"checked":"")+" value=\"true\" border=\"0\" >";
    }

    public static boolean checkBox(String name, HttpServletRequest req)
    {
        String param = req.getParameter(name);
        return (param != null && param.equals("true"));
    }
}
