package com.corejdo.casestudy.usecase;

import com.corejdo.casestudy.tools.CmdLine;

/**
 * Prosta aplikacja, ktra wczytuje polecenie i wykonuje
 * wybrany w ten sposb przypadek uycia.
 *
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class Main
{
    public static Context mainContext = new Context();

    public static void main(String args[])
    {
        if (args.length == 1) {
            doCommand(args[0]);
        } else {
            String cmd = "ListBooks";
            while (true) {
                cmd = CmdLine.getStringVar("Use case",cmd);
                doCommand(cmd);
            }
        }
    }

    public static void doCommand(String cmd)
    {
        if (cmd.equals("exit")) {
            mainContext.close();
            System.exit(0);
        }
        String className = "com.corejdo.casestudy.usecase."+cmd;
        try
        {
            Class clazz = Class.forName(className);
            AbstractUseCase uc = (AbstractUseCase)clazz.newInstance();
            String[] args = { };
            uc.setContext(mainContext);
            uc.run(args);
        }
        catch (Exception ex)
        {
            ex.printStackTrace();
        }
    }

}
