package com.corejdo.casestudy.usecase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.jdo.Extent;
import javax.jdo.Query;

import com.corejdo.casestudy.model.Book;
import com.corejdo.casestudy.tools.CmdLine;

/**
 * Tworzy list ksiek.
 *
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class ListBooks
    extends BookOperation
{
    int startNumber = 0;
    int count = 10;
    List result;

    String filterAuthor = "";
    Query query;
    Extent extent;

    /**
     * Okrela pocztkowe przesunicie. Poniewa JDO nie posiada
     * operacji "seek" dla ekstensji, to implementujemy wasn wywoujc iterator.next().
     * @param i
     */
    public void setStartNumber(int i)
    {
        startNumber = i;
    }

    /**
     * Okrela liczb pozycji zwracan przez t operacj.
     * @param i liczba pozycji
     */
    public void setCount(int i)
    {
        count = i;
    }

    /**
     * Obiekt uywany do zwrcenia wyniku.
     * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
     * @version 1.0
     */
    public class BookDTO
    {
        public final String title;
        public final String copyright;
        public final String ISBN;
        public final String author;

        BookDTO(Book b)
        {
            this.title = b.title;
            this.copyright = b.copyright;
            this.ISBN = b.ISBN;
            this.author = b.author;
        }

        public String toString()
        {
            return   "Tytu:  "+title+
                   "\n   Autor: "+author+
                   "\n   ISBN:   "+ISBN+
                   "\n   (C):    "+copyright;
        }
    }

    /**
     * Przeglda elementy ekstensji ksiek.
     * Poniewa JDO nie udostpnia operacji "seek" 
     * to implementujemy j wywoujc iterator.next()
     * zaczynajc od pozycji pocztkowej.
     */
    protected void _execute()
    {
        result = new ArrayList();
        extent = getPM().getExtent(Book.class,true);
        query = null;
        Iterator iter = filter(extent);
        int i = this.startNumber;
        while (i-- > 0 && iter.hasNext()) iter.next();
        i = this.count;
        while (i-- > 0 && iter.hasNext()) {
            result.add(new BookDTO((Book)iter.next()));
        }
        if (query != null) {
            query.close(iter);
        } else {
            extent.close(iter);
        }
    }

    protected Iterator filter(Extent extent)
    {
        if (filterAuthor != null && filterAuthor.length() > 0) {
            query = getPM().newQuery(Book.class, "author == val");
            query.declareParameters("java.lang.String val");
            query.setCandidates(extent);
            Collection result = (Collection)query.execute(filterAuthor);
            return result.iterator();
        } else {
            return extent.iterator();
        }
    }

    /**
     * Wersja uruchamiana z wiersza polece.
     */
    public static void main(String[] args) {
        new ListBooks().runCmdLine(args);
    }

    protected void run(String[] args) {
        setStartNumber(CmdLine.getIntVar("Pocztek:",0));
        setCount(CmdLine.getIntVar("Liczba:",10));
        execute();
        System.out.println("Wynik: ");
        Iterator iter = getResult();
        int i = 1;
        while (iter.hasNext()) {
            System.out.println(""+i+": "+iter.next());
            i++;
        }
    }

    /**
     * Zwrcony operator zwraca obiekty BookDTO .
     */
    public Iterator getResult()
    {
        return result.iterator();
    }
    public int getCount()
    {
        return count;
    }
    public int getStartNumber()
    {
        return startNumber;
    }
    public String getFilterAuthor()
    {
        return filterAuthor;
    }
    public void setFilterAuthor(String filterAuthor)
    {
        this.filterAuthor = filterAuthor;
    }
}

