package com.corejdo.casestudy.usecase;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;

import javax.jdo.Extent;

import com.corejdo.casestudy.model.Book;
import com.corejdo.casestudy.model.CD;
import com.corejdo.casestudy.model.Copy;
import com.corejdo.casestudy.model.Publication;
import com.corejdo.casestudy.model.Right;
import com.corejdo.casestudy.model.User;

/**
 * Usuwa zawarto bazy danych i wstawia nowe dane.
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */
public class FillDatabase extends AbstractUseCase
{
    /**
     * Wersja uruchamiana w wierszu polece.
     */
    public static void main(String args[])
    {
        new FillDatabase().runCmdLine(args);
    }

    /**
     * Metoda wywoywana przez szkielet.
     */
    protected void run(String[] parm1)
    {
        execute();
    }

    /**
     * Usuwa wszystkie obiekty z bazy danych
     * i wstawia nowe.
     */
    protected void _execute()
    {
        // usuwanie obiektw z bazy:
        Extent objects = getPM().getExtent(java.lang.Object.class,true);
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            getPM().deletePersistent(iter.next());
        }
        getPM().currentTransaction().commit();
        getPM().currentTransaction().begin();

        // wstawia nowego menedera biblioteki:
        User u = new User();
        u.setFirstName("Super");
        u.setLastName("User");
        u.setId("su");
        u.setPassword("su");
        u.getRights().setBorrow(Right.ALLOWED);
        u.getRights().setManage(Right.ALLOWED);
        u.getRights().setModifyUser(Right.ALLOWED);
        getPM().makePersistent(u);
        for (int i = 0; i < 1000; i++) {
            if (rnd.nextInt(100) > 50) {
                addRandomBook(u);
            } else {
                addRandomCD(u);
            }
        }
    }

    Random rnd = new Random();

    /**
     * Tworzy obiekt reprezentujcy ksik i wypenia jego pola przypadkowymi danymi.
     * Tworzy rwnie kopie ksiki.
     * @param insertedBy uytkownik, ktry doda ksik.
     */
    private void addRandomBook(User insertedBy)
    {
        Book b = new Book();

        String s1 = Integer.toString(rnd.nextInt(10));
        String s2 = Integer.toString(rnd.nextInt(9000)+1000);
        String s3 = Integer.toString(rnd.nextInt(9000)+1000);
        String s4 = Integer.toString(rnd.nextInt(10));
        b.ISBN = s1+"-"+s2+"-"+s3+"-"+s4;

        int n1 = rnd.nextInt(firstNames.length);
        int n2 = rnd.nextInt(lastNames.length);
        b.author = lastNames[n2]+", "+firstNames[n1];

        addRandomPublication(b,insertedBy);

    }

    void addRandomPublication(Publication publication, User insertedBy)
    {
        publication.insertedBy = insertedBy;

        int n1 = rnd.nextInt(booktitles.length)/2;
        int n2 = rnd.nextInt(nouns.length);
        publication.title = booktitles[n1*2]+nouns[n2]+booktitles[n1*2+1];

        n1 = rnd.nextInt(publishers.length);
        publication.copyright = publishers[n1];
        long pubDate = date(rnd.nextInt(100)+1900,rnd.nextInt(12),rnd.nextInt(28)).getTime();
        long now = new Date().getTime();
        publication.firstPublished = new Date(pubDate);
        long time = rnd.nextLong() & 0xFFFFFFFFFFL;
        publication.published = new Date(pubDate + (time % (now-pubDate)));
        getPM().makePersistent(publication);
        addRandomCopies(publication);
    }

    void addRandomCopies(Publication publication)
    {
        int copies = rnd.nextInt(5)+1;
        int aisle1 = rnd.nextInt(12)+1;
        char aisle2 = (char)(rnd.nextInt(26)+'A');
        int shelf1 = rnd.nextInt(6)+1;
        int shelf2 = rnd.nextInt(6)+10;
        for (int i = 0; i < copies; i++) {
            Copy copy = new Copy(publication);
            copy.location = "Rega "+aisle1+""+aisle2+" Pka "+shelf1+"-"+shelf2;
            getPM().makePersistent(copy);
        }
    }

    /**
     * Tworzy obiekt reprezentujcy pyt CD i wypenia go przypadkowymi danymi.
     * Tworzy rwnie kopie publikacji.
     * @param insertedBy uytkownik, ktry doda pyt.
     */
    private void addRandomCD(User insertedBy)
    {
        String s1 = Integer.toString(rnd.nextInt(9000)+1000);
        String s2 = Integer.toString(rnd.nextInt(10));
        String s3 = Integer.toString(rnd.nextInt(10));
        String s4 = Integer.toString(rnd.nextInt(9000)+1000);
        String refNo = s1+"."+s2+"."+s3+"."+s4;

        CD cd = new CD(refNo);
        cd.insertedBy = insertedBy;

        addRandomPublication(cd,insertedBy);


        int songs = rnd.nextInt(10)+4;
        for (int i = 0; i < songs; i++) {
            int n1 = rnd.nextInt(songtitles.length)/2;
            int n2 = rnd.nextInt(nouns2.length);
            String title = songtitles[n1*2]+nouns2[n2]+songtitles[n1*2+1];
            n1 = rnd.nextInt(firstNames.length);
            n2 = rnd.nextInt(lastNames.length);
            String composer = lastNames[n2]+", "+firstNames[n1];
            int seconds = rnd.nextInt(2400)+300;
            cd.addSong(composer, title, seconds);
        }

    }

    /**
     * Dodaje ksik. Tworzy now instancj klasy Book 
     * i wywouje metod pm.makePersistent.
     */
    private void addBook(User who, String author, String title,
        String copyright, Date firstPublished, String ISBN)
    {
        Book b = new Book();
        b.insertedBy = who;
        b.author = author;
        b.title = title;
        b.copyright = copyright;
        b.firstPublished = firstPublished;
        getPM().makePersistent(b);
    }

    /**
     * Zwraca obiekt klasy Date dla biecego dnia.
     * @param year
     * @param month
     * @param day
     * @return Date 
     */
    private static Date date(int year, int month, int day)
    {
        Calendar cal = Calendar.getInstance();
        cal.set(year,month-1,day);
        return cal.getTime();
    }

    private static final String[] firstNames = {
        "Abe", "Bert", "Chris", "Dennis", "Edward", "Fritz",
        "George", "Hugo", "Isaac", "John", "Kurt", "Lenny",
        "Martin", "Norman", "Oscar", "Pete", "Robert", "Stuart",
        "Tom", "Ulf", "Victor", "Will",
        "Ann", "Bridget", "Chris", "Debbie", "Eliza", "Francis",
        "Hannah", "Isa", "Jennifer", "K", "Lea",
        "Maria", "Norma", "Ottilie", "Petra", "Roberta", "Sarah",
        "Tamara", "Vera", "Wes",
        };

    private static final String[] lastNames = {
        "Anston", "Bogarek", "Canna", "Deta", "Ennis", "Folkston",
        "Gilbertson", "Hannover", "Idaka", "Joseph", "Kensington",
        "Larson", "Morris", "Newly", "Olson", "Patricks", "Remings",
        "Solting", "Utah", "Verton", "Wilson",
        };
    private static final String[] publishers = {
        "Jonathan Publishing Co.",
        "O'Renny",
        "Morgue and Klugman",
        "Frantic Hell",
        "Nanosoft Press",
        };

    private static final String[] nouns = {
        "Africa", "Barbados", "China", "Denmark", "England",
        "France", "Germany", "Hungary", "Iceland", "Jordan",
        "Kenya", "Laos", "Mexico", "Norway", "Oman", "Persia",
        "Qatar", "Romania", "Sweden", "Tasmania", "Uruguay", "Venezuela",
        };

    private static final String[] booktitles = {
        "Travel Guide: ","",
        "Biking through ","",
        "Bad News From ","",
        "Sailing around ","",
        "Welcome to ","",
        "How To Get a Job in ","",
        ""," For Dummies",
        "How "," Changed My Life",
    };

    private static final String[] nouns2 = {
        "Gold", "Silver", "Platinum", "Water", "Fire",
        "Silence", "Freedom", "Copper", "Oxygen", "Chromium",
        "Mercury", "Garbage", "Pointers", "Zeroes"
        };

    private static final String[] songtitles = {
        "A Sphere of ","",
        "The Pyramid of ","",
        ""," and Cubes",
        "Hyperbolic ","",
        ""," Paintings",
        ""," Noise",
        ""," XML",
        "Tale of "," and J2EE",
    };
}
