package com.corejdo.casestudy.usecase;

import com.corejdo.casestudy.model.Book;
import com.corejdo.casestudy.model.Copy;
import com.corejdo.casestudy.tools.CmdLine;

/**
 * Pobiera szczegowe informacje o ksice.
 * Stanowi dobry przykad ukrywania danych. 
 * Rzeczywiste dane klasy trwaej Book zawieraj
 * informacj o czytelniku, ktry wypoyczy ksik.
 * Nieuprawnieni uytkownicy nie powinni mie dostepu.
 * do tej informacji.
 *i
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */
public class DetailedBook extends BookOperation
{

    public DetailedBook()
    {
    }

    public static void main(String[] args)
    {
        new DetailedBook().runCmdLine(args);
    }

    /**
     * Wersja edytora dostpna w wierszu polece.
     */
    protected void run(String[] args)
    {
        setFindISBN(CmdLine.getStringVar("Podaj ISBN","928394-234-23444"));
        setFindTitle(CmdLine.getStringVar("Podaj tytu",""));
        execute();
    }

    /**
     * Najpierw wyszukuje ksik, a potem zwraca szczegowe
     * informacje. Implementacja tej metodyjest prosta, poniewa
     * JDO wykonuje za nas wiele operacji takich jak na przykad
     * pobieranie obiektw na danie.
     */
    protected void _execute()
    {
        Book book = findBook();
        this.ISBN = book.ISBN;
        this.author = book.author;
        this.title = book.title;
        this.published = book.published.toString();
        this.firstPublished = book.firstPublished.toString();
        Copy copies[] = findCopies(book);
        availableCopies = 0;
        for (int i = 0; i < copies.length; i++) {
            if (copies[i].borrower == null) availableCopies++;
        }
        this.isBorrowed = availableCopies > 0;
    }

    public String getAuthor()
    {
        return author;
    }
    public int getAvailableCopies()
    {
        return availableCopies;
    }
    public String getFirstPublished()
    {
        return firstPublished;
    }
    public String getISBN()
    {
        return ISBN;
    }
    public boolean isIsBorrowed()
    {
        return isBorrowed;
    }
    public String getPublished()
    {
        return published;
    }
    public String getTitle()
    {
        return title;
    }

    String ISBN;
    String author;
    String title;
    String published;
    String firstPublished;
    int availableCopies;
    boolean isBorrowed;
}
