package com.corejdo.casestudy.model;

import java.util.Date;

/**
 * Reprezentuje fizyczn kopi publikacji w bibliotece. Kopia
 * moe znajdowa si w bibliotece lub by wypoyczona.
 * Kopia moe by rwnie: zagubiona (missing), uszkodzona (damaged) lub sprzedana (sold).
 * Uytkownik moe zarezerwowa publikacj, ale nie konkretn kopi.
 *
 * <BR><FONT Color="red"><B>Trwaa</B></FONT>
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class Copy
{
    /**
     * Okrela publikacj dla danej kopii.
     */
    public Publication copyOf;

    /**
     * Znacznik ustawiany, gdy minie czas wypoyczenia.
     */
    public boolean missing;
    /**
     *  Znacznik ustawiany, gdy kopia jest uszkodzona.
     */
    public boolean damaged;
    /**
     *  Znacznik ustawiany, gdy kopia zostanie sprzedana.
     */
    public boolean sold;
    /**
     * Opis pooenia kopii w bibliotece.
     */
    public String location;
    /**
     * Referencja czytelnika, ktry wypoyczy kopi. 
     */
    public User borrower;
    /**
     * Data wypoyczenia publikacji.
     */
    public Date borrowDate;
    /**
     * Data, do ktrej kopia powinna zosta zwrcona do biblioteki.
     */
    public Date returnDate;

    public Copy(Publication copyOf)
    {
        this.copyOf = copyOf;
        this.location = "entry";
    }

    private Copy()
    {
    }

}
